/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.AnonymousIdentification;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.tasks.LaunchTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelExitTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelLoadTask;
import dev.ftb.mods.ftbauxilium.utils.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatManager.class);
    private static final AnonymousIdentification IDENTIFIER = new AnonymousIdentification();
    private float loadTimeInSeconds = 0.0f;
    private ModpackData packData;
    private String sessionToken = "";
    private SessionCollector session;
    private Launchers launcher = Launchers.UNKNOWN;

    public static AnonymousIdentification identifier() {
        return IDENTIFIER;
    }

    public void init(IEventBus eventBus) {
        FTBAuxilium.LOGGER.debug("Starting stat system");
        this.packData = new ModpackData();
        eventBus.addListener(this::onClientSetup);
        NeoForge.EVENT_BUS.addListener(this::worldLoaded);
        NeoForge.EVENT_BUS.addListener(this::onLevelExit);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        if (StatManager.identifier().isOptedOut()) {
            return;
        }
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.loadTimeInSeconds = (float)uptime / 1000.0f;
        this.launcher = this.findLauncher();
        FTBAuxilium.LOGGER.info("Launcher found: {}", (Object)this.launcher.getName());
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LaunchTask(this.launcher)));
    }

    public void worldLoaded(ClientPlayerNetworkEvent.LoggingIn event) {
        if (StatManager.identifier().isOptedOut()) {
            return;
        }
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LevelLoadTask(event.getPlayer())));
    }

    public void onLevelExit(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() == null || StatManager.identifier().isOptedOut()) {
            return;
        }
        Minecraft.getInstance().execute(() -> FTBAuxilium.runTask(new LevelExitTask()));
    }

    private Launchers findLauncher() {
        File gameDirectory = Minecraft.getInstance().gameDirectory.getAbsoluteFile();
        String versionArg = Utils.getVersionArg().toLowerCase();
        for (Launchers value : Launchers.VALUES) {
            if (value == Launchers.UNKNOWN) continue;
            if (value.checker != null && value.checker.test(versionArg)) {
                return value;
            }
            if (value.identifierPath.isEmpty() || !value.exists(gameDirectory)) continue;
            return value;
        }
        LOGGER.warn("Unable to find launcher, attempted {} known launchers, search within {}", (Object)Launchers.values().length, (Object)versionArg);
        return Launchers.UNKNOWN;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public ModpackData getPackData() {
        return this.packData;
    }

    public float getLoadTimeInSeconds() {
        return this.loadTimeInSeconds;
    }

    public SessionCollector getSession() {
        return this.session;
    }

    public void setSession(SessionCollector session) {
        this.session = session;
    }

    public static enum Launchers {
        FTB(100, "FTB App", "/version.json"),
        CURSE(90, "Curse", "/.curseclient"),
        PRISM(75, "Prism", "/../../../prismlauncher.cfg"),
        POLYMC(80, "PolyMC", version -> version.contains("polymc")),
        MULTI(75, "MultiMc", version -> version.contains("multimc")),
        MODRINTH(70, "Modrinth", "/profile.json"),
        GD(70, "GDLauncher", "/config.json"),
        GD_CARBON(70, "GDLauncher Carbon", "/instance.json"),
        ATLAUNCHER(60, "ATLancher", "/instance.png"),
        TLAUNCHER(50, "TLancher", "/../../tlauncher_libraries"),
        UNKNOWN(5, "unknown", "");

        final String name;
        final String identifierPath;
        final int priority;
        @Nullable
        final Predicate<String> checker;
        public static final Launchers[] VALUES;

        private Launchers(int priority, String name, String identifierPath) {
            this.name = name;
            this.identifierPath = identifierPath;
            this.priority = priority;
            this.checker = null;
        }

        private Launchers(@Nullable int priority, String name, Predicate<String> checker) {
            this.name = name;
            this.identifierPath = "";
            this.priority = priority;
            this.checker = checker;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists(File minecraftDir) {
            return Files.exists(Paths.get(String.valueOf(minecraftDir) + this.identifierPath, new String[0]), new LinkOption[0]) || Files.isDirectory(Paths.get(String.valueOf(minecraftDir) + this.identifierPath, new String[0]), new LinkOption[0]);
        }

        public int getPriority() {
            return this.priority;
        }

        static {
            VALUES = (Launchers[])Arrays.stream(Launchers.values()).sorted(Comparator.comparing(Launchers::getPriority).reversed()).toArray(Launchers[]::new);
        }
    }
}

