/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.SendPlayerPositionPacket;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public enum LongRangePlayerTracker {
    INSTANCE;

    private long lastTick = 0L;
    private final Table<UUID, UUID, BlockPos> trackingMap = HashBasedTable.create();

    public void tick(MinecraftServer server) {
        int interval = (Integer)FTBChunksWorldConfig.LONG_RANGE_TRACKER_INTERVAL.get();
        if (interval != 0 && (long)server.getTickCount() - this.lastTick > (long)interval) {
            this.lastTick = server.getTickCount();
            List players = server.getPlayerList().getPlayers();
            int maxDistSq = server.getPlayerList().getViewDistance() * server.getPlayerList().getViewDistance() * 256;
            players.forEach(trackingPlayer -> trackingPlayer.level().players().forEach(p2a -> {
                if (p2a instanceof ServerPlayer) {
                    ServerPlayer trackedPlayer = (ServerPlayer)p2a;
                    if (this.shouldTrack((ServerPlayer)trackingPlayer, trackedPlayer, maxDistSq)) {
                        BlockPos lastPos = (BlockPos)this.trackingMap.get((Object)trackingPlayer.getUUID(), (Object)trackedPlayer.getUUID());
                        if (lastPos == null || trackedPlayer.blockPosition().distSqr((Vec3i)lastPos) > 16.0) {
                            NetworkManager.sendToPlayer((ServerPlayer)trackingPlayer, (CustomPacketPayload)SendPlayerPositionPacket.startTracking(trackedPlayer));
                            this.trackingMap.put((Object)trackingPlayer.getUUID(), (Object)trackedPlayer.getUUID(), (Object)trackedPlayer.blockPosition());
                        }
                    } else if (this.trackingMap.contains((Object)trackingPlayer.getUUID(), (Object)trackedPlayer.getUUID())) {
                        NetworkManager.sendToPlayer((ServerPlayer)trackingPlayer, (CustomPacketPayload)SendPlayerPositionPacket.stopTracking(trackedPlayer));
                        this.trackingMap.remove((Object)trackingPlayer.getUUID(), (Object)trackedPlayer.getUUID());
                    }
                }
            }));
        }
    }

    public void stopTracking(ServerPlayer player) {
        if (player.getServer() == null) {
            return;
        }
        HashMap<UUID, UUID> toRemove = new HashMap<UUID, UUID>();
        for (UUID trackingId2 : this.trackingMap.rowKeySet()) {
            if (!this.trackingMap.contains((Object)trackingId2, (Object)player.getUUID())) continue;
            toRemove.put(trackingId2, player.getUUID());
        }
        toRemove.forEach((trackingId, disconnectedId) -> {
            ServerPlayer trackingPlayer = player.getServer().getPlayerList().getPlayer(trackingId);
            if (trackingPlayer != null) {
                NetworkManager.sendToPlayer((ServerPlayer)trackingPlayer, (CustomPacketPayload)SendPlayerPositionPacket.stopTracking(player));
            }
            this.trackingMap.remove(trackingId, disconnectedId);
        });
    }

    private boolean shouldTrack(ServerPlayer p1, ServerPlayer p2, int maxDistSq) {
        if (p1 == p2 || p1.distanceToSqr((Entity)p2) < (double)maxDistSq) {
            return false;
        }
        if (((Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get()).booleanValue()) {
            return true;
        }
        ChunkTeamDataImpl p2Team = ClaimedChunkManagerImpl.getInstance().getOrCreateData(p2);
        return p2Team != null && p2Team.canPlayerUse(p1, FTBChunksProperties.LOCATION_MODE);
    }
}

