/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.EntityIconLoader;
import dev.ftb.mods.ftblibrary.icon.EntityImageIcon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.IntTextBox;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ToggleableButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class SliceCreationGUI
extends BaseScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntityType<?> entityType;
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation texture;
    private final SliceControlBox sliceControlBox;
    private final SimpleButton exportButton;
    private final IntTextBox imageSizeX;
    private final IntTextBox imageSizeY;
    private final List<SliceControlBox> sliceControlBoxes;
    private int currentSlice = 0;
    private SliceControlBox activeSlice;
    private final SimpleButton addSlice;
    private final SimpleButton removeSlice;
    private final SimpleButton nextSlice;
    private final SimpleButton previousSlice;

    public SliceCreationGUI(EntityType<?> entityType) {
        this.entityType = entityType;
        this.sliceControlBoxes = new ArrayList<SliceControlBox>();
        this.imageSizeX = new IntTextBox((Panel)this);
        this.imageSizeY = new IntTextBox((Panel)this);
        this.imageSizeX.setAmount(16);
        this.imageSizeY.setAmount(16);
        Entity entity = entityType.create((Level)Minecraft.getInstance().level);
        this.texture = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity).getTextureLocation(entity);
        this.exportButton = this.createExportButton();
        Pair<Integer, Integer> textureSize = this.getTextureSize();
        this.textureWidth = (Integer)textureSize.getFirst();
        this.textureHeight = (Integer)textureSize.getSecond();
        this.sliceControlBox = new SliceControlBox((Panel)this, this.texture, this.textureWidth, this.textureHeight, false);
        this.addSlice = new SimpleButton((Panel)this, (Component)Component.literal((String)"Add Slice"), Icons.ADD, (button1, mouseButton1) -> {
            SliceControlBox sliceControlBox = new SliceControlBox((Panel)this, this.texture, this.textureWidth, this.textureHeight, true);
            this.sliceControlBoxes.add(sliceControlBox);
            this.currentSlice = this.sliceControlBoxes.size() - 1;
            this.activeSlice = sliceControlBox;
            button1.getGui().refreshWidgets();
        });
        this.removeSlice = new SimpleButton((Panel)this, (Component)Component.literal((String)"Remove Slice"), Icons.REMOVE, (button1, mouseButton1) -> {
            if (!this.sliceControlBoxes.isEmpty()) {
                this.sliceControlBoxes.remove(this.currentSlice);
                this.currentSlice = Math.max(0, Math.min(this.sliceControlBoxes.size() - 1, this.currentSlice));
                this.activeSlice = this.sliceControlBoxes.isEmpty() ? null : this.sliceControlBoxes.get(this.currentSlice);
                button1.getGui().refreshWidgets();
            }
        });
        this.nextSlice = new SimpleButton((Panel)this, (Component)Component.literal((String)"Next Slice"), Icons.DOWN, (button1, mouseButton1) -> {
            if (!this.sliceControlBoxes.isEmpty()) {
                this.currentSlice = Math.max(0, Math.min(this.sliceControlBoxes.size() - 1, this.currentSlice + 1));
                this.activeSlice = this.sliceControlBoxes.get(this.currentSlice);
                button1.getGui().refreshWidgets();
            }
        });
        this.previousSlice = new SimpleButton((Panel)this, (Component)Component.literal((String)"Previous Slice"), Icons.UP, (button1, mouseButton1) -> {
            if (!this.sliceControlBoxes.isEmpty()) {
                this.currentSlice = Math.max(0, Math.min(this.sliceControlBoxes.size() - 1, this.currentSlice - 1));
                this.activeSlice = this.sliceControlBoxes.get(this.currentSlice);
                button1.getGui().refreshWidgets();
            }
        });
        this.loadExistingSettings();
    }

    public void addWidgets() {
        this.activeSlice = null;
        this.add((Widget)this.sliceControlBox);
        this.add((Widget)this.exportButton);
        this.add((Widget)this.imageSizeX);
        this.add((Widget)this.imageSizeY);
        this.add((Widget)this.addSlice);
        this.add((Widget)this.removeSlice);
        this.add((Widget)this.nextSlice);
        this.add((Widget)this.previousSlice);
        if (!this.sliceControlBoxes.isEmpty()) {
            int slice = Math.max(0, Math.min(this.sliceControlBoxes.size() - 1, this.currentSlice));
            SliceControlBox widget = this.sliceControlBoxes.get(slice);
            this.add((Widget)widget);
            this.activeSlice = widget;
        }
    }

    public void alignWidgets() {
        this.setSizeProportional(1.0f, 1.0f);
        int oneFourth = this.width / 4;
        this.sliceControlBox.setPosAndSize(2, 60, oneFourth, 60);
        this.exportButton.setPosAndSize(28, 0, 20, 20);
        this.imageSizeX.setPosAndSize(2, 25, 20, 20);
        this.imageSizeY.setPosAndSize(27, 25, 20, 20);
        if (this.activeSlice != null) {
            this.activeSlice.setPosAndSize(2, 140, oneFourth, 60);
        }
        this.addSlice.setPosAndSize(0, 120, 8, 8);
        this.removeSlice.setPosAndSize(10, 120, 8, 8);
        this.nextSlice.setPosAndSize(20, 120, 8, 8);
        this.previousSlice.setPosAndSize(30, 120, 8, 8);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
        int oneFourth = w / 4;
        Color4I.BLACK.draw(graphics, oneFourth, y, 4, h);
        theme.drawHorizontalTab(graphics, x + 20, y, w, h, false);
        graphics.pose().pushPose();
        graphics.pose().scale(2.0f, 2.0f, 0.0f);
        this.sliceControlBox.drawMainTexture(graphics, oneFourth + 5, y);
        this.sliceControlBox.drawOverlay(graphics, oneFourth + 5, y);
        for (SliceControlBox controlBox : this.sliceControlBoxes) {
            controlBox.drawOverlay(graphics, oneFourth + 5, y);
        }
        graphics.pose().popPose();
        ArrayList<EntityImageIcon.ChildIconData> slices = new ArrayList<EntityImageIcon.ChildIconData>();
        for (SliceControlBox controlBox : this.sliceControlBoxes) {
            slices.add(new EntityImageIcon.ChildIconData(Optional.empty(), controlBox.createSlice(), Optional.of(new EntityImageIcon.Offset(controlBox.offsetXText.getIntValue(), controlBox.offsetYText.getIntValue()))));
        }
        new EntityImageIcon(this.sliceControlBox.texture, this.sliceControlBox.createSlice(), slices, null).draw(graphics, x + 2, y + 2, this.imageSizeX.getIntValue(), this.imageSizeY.getIntValue());
    }

    public void drawForeground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(graphics, theme, x, y, w, h);
    }

    private SimpleButton createExportButton() {
        return new SimpleButton((Panel)this, (Component)Component.literal((String)"Export"), Icons.STAR, (button, mouseButton) -> {
            SliceCreationGUI bu = (SliceCreationGUI)button.getGui();
            EntityIconLoader.EntityIconSettings entityIconSettings = new EntityIconLoader.EntityIconSettings(true, Optional.empty(), Optional.of(bu.sliceControlBox.createSlice()), bu.sliceControlBoxes.stream().map(box -> new EntityImageIcon.ChildIconData(Optional.empty(), box.createSlice(), Optional.of(new EntityImageIcon.Offset(box.offsetXText.getIntValue(), box.offsetYText.getIntValue())))).toList(), EntityIconLoader.WidthHeight.DEFAULT, Optional.empty(), 1.0, true);
            EntityIconLoader.EntityIconSettings.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entityIconSettings).result().ifPresent(jsonElement -> {
                Path path = Platform.getGameFolder().resolve("export");
                try {
                    ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType);
                    String path1 = key.getNamespace() + "/" + key.getPath();
                    Path resolve = path.resolve(path1 + ".json");
                    if (!Files.exists(resolve.getParent(), new LinkOption[0])) {
                        Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                    }
                    Files.write(resolve, jsonElement.toString().getBytes(), new OpenOption[0]);
                    SimpleToast.info((Component)Component.literal((String)"Saved File"), (Component)Component.empty());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        });
    }

    private void loadExistingSettings() {
        EntityIconLoader.getSettings(this.entityType).ifPresent(settings -> {
            settings.mainSlice().ifPresent(slice -> {
                this.sliceControlBox.xText.setAmount(slice.x());
                this.sliceControlBox.yText.setAmount(slice.y());
                this.sliceControlBox.wText.setAmount(slice.width());
                this.sliceControlBox.hText.setAmount(slice.height());
            });
            settings.children().forEach(child -> {
                SliceControlBox sliceControlBox = new SliceControlBox((Panel)this, this.texture, this.textureWidth, this.textureHeight, true);
                EntityImageIcon.Slice slice1 = child.slice();
                sliceControlBox.xText.setAmount(slice1.x());
                sliceControlBox.yText.setAmount(slice1.y());
                sliceControlBox.wText.setAmount(slice1.width());
                sliceControlBox.hText.setAmount(slice1.height());
                child.offset().ifPresent(offset -> {
                    sliceControlBox.offsetXText.setAmount(offset.x());
                    sliceControlBox.offsetYText.setAmount(offset.y());
                });
                this.sliceControlBoxes.add(sliceControlBox);
                this.activeSlice = sliceControlBox;
            });
        });
    }

    private Pair<Integer, Integer> getTextureSize() {
        SimpleTexture.TextureImage textureImage = SimpleTexture.TextureImage.load((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)this.texture);
        try {
            int imageWidth = textureImage.getImage().getWidth();
            int imageHeight = textureImage.getImage().getHeight();
            return Pair.of((Object)imageWidth, (Object)imageHeight);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get texture size for {}", (Object)this.texture, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static class SliceControlBox
    extends Panel {
        private final ImageIcon mainIcon;
        private final ResourceLocation texture;
        private final IntTextBox xText;
        private final IntTextBox yText;
        private final IntTextBox wText;
        private final IntTextBox hText;
        private final int imageWidth;
        private final int imageHeight;
        private final ColorButton colorButton = new ColorButton(this, Color4I.WHITE);
        private final boolean offset;
        private final IntTextBox offsetXText;
        private final IntTextBox offsetYText;
        private final Button toggleOverlay;
        private boolean overlay = true;

        public SliceControlBox(Panel p, ResourceLocation texture, int imageWidth, int imageHeight, boolean offset) {
            super(p);
            this.mainIcon = new ImageIcon(texture);
            this.texture = texture;
            this.xText = new IntTextBox((Panel)this);
            this.add((Widget)this.xText);
            this.xText.setAmount(0);
            this.yText = new IntTextBox((Panel)this);
            this.add((Widget)this.yText);
            this.yText.setAmount(0);
            this.wText = new IntTextBox((Panel)this);
            this.add((Widget)this.wText);
            this.hText = new IntTextBox((Panel)this);
            this.add((Widget)this.hText);
            this.wText.setAmount(imageWidth);
            this.hText.setAmount(imageHeight);
            this.wText.setMinMax(1, imageWidth);
            this.hText.setMinMax(1, imageHeight);
            this.xText.setMinMax(0, imageWidth);
            this.yText.setMinMax(0, imageHeight);
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.offset = offset;
            this.offsetXText = new IntTextBox((Panel)this);
            this.offsetYText = new IntTextBox((Panel)this);
            this.offsetXText.setAmount(0);
            this.offsetYText.setAmount(0);
            this.toggleOverlay = new ToggleableButton((Panel)this, this.overlay, Icons.ACCEPT, Icons.REMOVE, (button, newState) -> {
                this.overlay = newState;
            });
        }

        public void addWidgets() {
            this.add((Widget)this.xText);
            this.add((Widget)this.yText);
            this.add((Widget)this.wText);
            this.add((Widget)this.hText);
            this.add((Widget)this.colorButton);
            this.add((Widget)this.toggleOverlay);
            if (this.offset) {
                this.add((Widget)this.offsetXText);
                this.add((Widget)this.offsetYText);
            }
        }

        public void alignWidgets() {
            this.colorButton.setPosAndSize(50, 35, 20, 20);
            this.xText.setPosAndSize(0, 0, 20, 20);
            this.yText.setPosAndSize(25, 0, 20, 20);
            this.wText.setPosAndSize(50, 0, 20, 20);
            this.hText.setPosAndSize(75, 0, 20, 20);
            this.toggleOverlay.setPosAndSize(75, 35, 20, 20);
            if (this.offset) {
                this.offsetXText.setPosAndSize(0, 35, 20, 20);
                this.offsetYText.setPosAndSize(25, 35, 20, 20);
            }
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.drawBackground(graphics, theme, x, y, w, h);
            theme.drawString(graphics, (Object)"X", this.xText.getX() + 1, this.xText.getY() - theme.getFontHeight(), -16777216);
            theme.drawString(graphics, (Object)"Y", this.yText.getX() + 1, this.yText.getY() - theme.getFontHeight(), -16777216);
            theme.drawString(graphics, (Object)"W", this.wText.getX() + 1, this.wText.getY() - theme.getFontHeight(), -16777216);
            theme.drawString(graphics, (Object)"H", this.hText.getX() + 1, this.hText.getY() - theme.getFontHeight(), -16777216);
            if (this.offset) {
                theme.drawString(graphics, (Object)"OX", this.offsetXText.getX() + 1, this.offsetXText.getY() - theme.getFontHeight(), -16777216);
                theme.drawString(graphics, (Object)"OY", this.offsetYText.getX() + 1, this.offsetYText.getY() - theme.getFontHeight(), -16777216);
            }
        }

        public void drawMainTexture(GuiGraphics graphics, int x, int y) {
            this.mainIcon.draw(graphics, x, y, this.imageWidth, this.imageHeight);
        }

        public void drawOverlay(GuiGraphics graphics, int x, int y) {
            if (this.overlay) {
                this.colorButton.color4I.withAlpha(100).draw(graphics, x + this.xText.getIntValue(), y + this.yText.getIntValue(), this.wText.getIntValue(), this.hText.getIntValue());
            }
        }

        public EntityImageIcon.Slice createSlice() {
            return new EntityImageIcon.Slice(this.xText.getIntValue(), this.yText.getIntValue(), this.wText.getIntValue(), this.hText.getIntValue());
        }

        public int getW() {
            return this.wText.getIntValue();
        }

        public int getH() {
            return this.hText.getIntValue();
        }
    }

    private static class ColorButton
    extends SimpleButton {
        private Color4I color4I;

        public ColorButton(Panel panel, Color4I activeValue) {
            super(panel, (Component)Component.literal((String)""), Icons.COLOR_BLANK, null);
            this.color4I = activeValue;
            this.setConsumer((button, mouseButton) -> {
                int random = (int)Mth.randomBetween((RandomSource)Minecraft.getInstance().level.random, (float)0.0f, (float)255.0f);
                this.color4I = Color4I.get256((int)random);
            });
        }

        public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            theme.drawWidget(graphics, x, y, w, h, this.getWidgetType());
            Color4I.BLACK.withAlpha(125).draw(graphics, x + 2, y + 2, 12, 12);
            this.color4I.draw(graphics, x + 3, y + 3, 10, 10);
        }
    }
}

