/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map.color;

import com.mojang.blaze3d.platform.NativeImage;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorUtils {
    private static Color4I[] reducedColorPalette = null;
    private static Color4I[] topographyPalette = null;
    private static Color4I[][] lightMapPalette = null;
    private static final HashMap<Color4I, Color4I> reducedColorMap = new HashMap();

    public static int convertToNative(int c) {
        return FastColor.ABGR32.color((int)(c >> 24 & 0xFF), (int)(c >> 0 & 0xFF), (int)(c >> 8 & 0xFF), (int)(c >> 16 & 0xFF));
    }

    public static int convertFromNative(int c) {
        return FastColor.ABGR32.alpha((int)c) << 24 | FastColor.ABGR32.red((int)c) << 16 | FastColor.ABGR32.green((int)c) << 8 | FastColor.ABGR32.blue((int)c);
    }

    public static Color4I addBrightness(Color4I c, float f) {
        float r = c.redf() + f;
        float g = c.greenf() + f;
        float b = c.bluef() + f;
        int ri = Mth.clamp((int)((int)(r * 255.0f)), (int)0, (int)255);
        int gi = Mth.clamp((int)((int)(g * 255.0f)), (int)0, (int)255);
        int bi = Mth.clamp((int)((int)(b * 255.0f)), (int)0, (int)255);
        return Color4I.rgb((int)ri, (int)gi, (int)bi);
    }

    public static Color4I reduce(Color4I c) {
        if (reducedColorPalette == null) {
            reducedColorPalette = new Color4I[0];
            try (InputStream stream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(FTBChunksAPI.rl("textures/reduced_color_palette.png")).orElseThrow()).open();){
                NativeImage image = NativeImage.read((InputStream)stream);
                int w = image.getWidth();
                int h = image.getHeight();
                reducedColorPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col2 = image.getPixelRGBA(x, y);
                        ColorUtils.reducedColorPalette[x + y * w] = Color4I.rgb((int)(FastColor.ABGR32.red((int)col2) << 16 | FastColor.ABGR32.green((int)col2) << 8 | FastColor.ABGR32.blue((int)col2)));
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reducedColorPalette.length == 0) {
            return c;
        }
        return reducedColorMap.computeIfAbsent(c, col -> {
            int r = col.redi();
            int g = col.greeni();
            int b = col.bluei();
            long prevDist = Long.MAX_VALUE;
            Color4I colr = Color4I.BLACK;
            for (Color4I rcol : reducedColorPalette) {
                long db;
                long dg;
                long dr = r - rcol.redi();
                long d = dr * dr + (dg = (long)(g - rcol.greeni())) * dg + (db = (long)(b - rcol.bluei())) * db;
                if (d >= prevDist) continue;
                prevDist = d;
                colr = rcol;
            }
            return colr;
        });
    }

    public static Color4I[] getTopographyPalette() {
        if (topographyPalette == null) {
            topographyPalette = new Color4I[0];
            try (InputStream stream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(FTBChunksAPI.rl("textures/topography_palette.png")).orElseThrow()).open();){
                NativeImage image = NativeImage.read((InputStream)stream);
                int w = image.getWidth();
                int h = image.getHeight();
                topographyPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.getPixelRGBA(x, y);
                        ColorUtils.topographyPalette[x + y * w] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return topographyPalette;
    }

    public static Color4I[][] getLightMapPalette() {
        if (lightMapPalette == null) {
            lightMapPalette = new Color4I[0][0];
            try (InputStream stream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(FTBChunksAPI.rl("textures/lightmap_palette.png")).orElseThrow()).open();){
                NativeImage image = NativeImage.read((InputStream)stream);
                int w = image.getWidth();
                int h = image.getHeight();
                lightMapPalette = new Color4I[w][h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.getPixelRGBA(x, y);
                        ColorUtils.lightMapPalette[x][y] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lightMapPalette;
    }
}

