/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftbechoes.command.FTBEchoesCommands;
import dev.ftb.mods.ftbechoes.config.FTBEchoesServerConfig;
import dev.ftb.mods.ftbechoes.datagen.DataGenerators;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbechoes.net.SyncProgressMessage;
import dev.ftb.mods.ftbechoes.registry.ModArgumentTypes;
import dev.ftb.mods.ftbechoes.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbechoes.registry.ModBlocks;
import dev.ftb.mods.ftbechoes.registry.ModEntityTypes;
import dev.ftb.mods.ftbechoes.registry.ModItems;
import dev.ftb.mods.ftbechoes.registry.ModSounds;
import dev.ftb.mods.ftbechoes.registry.ModStageEntryTypes;
import dev.ftb.mods.ftbechoes.registry.RegistryKeys;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyHelper;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyProvider;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftblibrary.integration.stages.StageProvider;
import dev.ftb.mods.ftblibrary.nbtedit.NBTEditResponseHandlers;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="ftbechoes")
public class FTBEchoes {
    public static final String MOD_ID = "ftbechoes";
    public static final Logger LOGGER = LoggerFactory.getLogger(FTBEchoes.class);
    public static final Lazy<CurrencyProvider> CURRENCY_PROVIDER = Lazy.of(() -> CurrencyHelper.getInstance().getProvider());
    public static final Lazy<StageProvider> STAGE_PROVIDER = Lazy.of(() -> StageHelper.getInstance().getProvider());

    public FTBEchoes(IEventBus eventBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        ConfigManager.getInstance().registerServerConfig(FTBEchoesServerConfig.CONFIG, "ftbechoes.server_config", false);
        eventBus.addListener(this::addCreative);
        eventBus.addListener(DataGenerators::gatherData);
        eventBus.addListener(this::onNewRegistry);
        FTBEchoes.registerAll(eventBus);
        forgeBus.addListener(this::onServerAboutToStart);
        forgeBus.addListener(this::onServerStopped);
        forgeBus.addListener(this::onPlayerLogin);
        forgeBus.addListener(this::registerReloadListeners);
        forgeBus.addListener(FTBEchoesCommands::registerCommands);
        TeamEvent.PLAYER_LOGGED_IN.register(this::onPlayerTeamLogin);
        TeamEvent.PLAYER_CHANGED.register(this::onPlayerTeamChange);
    }

    public static CurrencyProvider currencyProvider() {
        return (CurrencyProvider)CURRENCY_PROVIDER.get();
    }

    public static StageProvider stageProvider() {
        return (StageProvider)STAGE_PROVIDER.get();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == FTBLibrary.getCreativeModeTab().get()) {
            event.accept((ItemLike)ModBlocks.ECHO_PROJECTOR.get());
        }
    }

    private static void registerAll(IEventBus eventBus) {
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(eventBus);
        ModEntityTypes.ENTITY_TYPES.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModStageEntryTypes.STAGE_ENTRY_TYPES.register(eventBus);
        ModArgumentTypes.COMMAND_ARGUMENT_TYPES.register(eventBus);
        ModSounds.SOUNDS.register(eventBus);
    }

    private void onServerAboutToStart(ServerAboutToStartEvent event) {
        EchoManager.initServer();
        NBTEditResponseHandlers.INSTANCE.registerHandler("ftbechoes:progress", (serverPlayer, info, data) -> FTBTeamsAPI.api().getManager().getTeamForPlayerID(info.getUUID("id")).ifPresent(team -> TeamProgress.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data).ifSuccess(progress -> {
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"ftbechoes.message.progress_edited", (Object[])new Object[]{team.getColoredName()}), false);
            TeamProgressManager.get(event.getServer()).injectProgressData(team.getTeamId(), (TeamProgress)progress);
        })));
    }

    private void onServerStopped(ServerStoppedEvent event) {
        EchoManager.shutdownServer();
    }

    private void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            EchoManager.getServerInstance().syncToClient(sp);
            this.checkForAutoclaimRewards(sp);
        }
    }

    private void checkForAutoclaimRewards(ServerPlayer sp) {
        TeamProgressManager mgr = TeamProgressManager.get(sp.getServer());
        mgr.getProgress(sp).ifPresent(progress -> {
            List<Pair<Echo, Integer>> res = progress.checkForAutoclaim(sp);
            if (!res.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)SyncProgressMessage.forPlayer(progress, sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
                sp.displayClientMessage((Component)Component.translatable((String)"ftbechoes.message.reward_claimed_offline"), false);
                res.forEach(echoAndStage -> {
                    MutableComponent msg = Component.literal((String)"\u2022 ").append(((Echo)echoAndStage.getFirst()).title()).append(" | ").append(((Echo)echoAndStage.getFirst()).stages().get((Integer)echoAndStage.getSecond()).title());
                    sp.displayClientMessage((Component)msg, false);
                });
                mgr.setDirty();
            }
        });
    }

    private void onPlayerTeamLogin(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        MinecraftServer server = Objects.requireNonNull(player.getServer());
        TeamProgress progress = TeamProgressManager.get(server).getProgress(event.getTeam());
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncProgressMessage.forPlayer(progress, player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (((Boolean)FTBEchoesServerConfig.SYNC_STAGES.get()).booleanValue()) {
            StageHelper.getInstance().getProvider().sync(player);
        }
    }

    private void onPlayerTeamChange(PlayerChangedTeamEvent event) {
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer instanceof ServerPlayer) {
            ServerPlayer sp = serverPlayer;
            MinecraftServer server = Objects.requireNonNull(sp.getServer());
            TeamProgress progress = TeamProgressManager.get(server).getProgress(event.getTeam());
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)SyncProgressMessage.forPlayer(progress, sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onNewRegistry(NewRegistryEvent event) {
        event.register(RegistryKeys.STAGE_ENTRY_REGISTRY);
    }

    private void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new EchoManager.ReloadListener(event.getRegistryAccess()));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

