/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.client.ClientProgress;
import dev.ftb.mods.ftbechoes.client.PersistedClientData;
import dev.ftb.mods.ftbechoes.client.gui.EchoScreen;
import dev.ftb.mods.ftbechoes.client.gui.StageEntryRenderers;
import dev.ftb.mods.ftbechoes.client.gui.Textures;
import dev.ftb.mods.ftbechoes.client.gui.widget.ClaimRewardButton;
import dev.ftb.mods.ftbechoes.client.gui.widget.CompleteStageButton;
import dev.ftb.mods.ftbechoes.client.gui.widget.HorizontalLineWidget;
import dev.ftb.mods.ftbechoes.client.gui.widget.ImageButton;
import dev.ftb.mods.ftbechoes.echo.BaseStageEntry;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.echo.entries.ImageEntry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

class LorePanel
extends EchoScreen.PagePanel {
    private final List<Widget> jumpPointWidgets = new ArrayList<Widget>();

    public LorePanel(Panel parent, EchoScreen echoScreen) {
        super(parent, echoScreen, EchoScreen.Page.LORE);
    }

    public void addWidgets() {
        this.getEcho().ifPresent(echo -> {
            this.jumpPointWidgets.clear();
            List<EchoStage> stages = echo.stages();
            int currentStage = ClientProgress.get().getCurrentStage(echo.id());
            boolean allCompleted = currentStage >= stages.size();
            int limit = Math.min(stages.size() - 1, currentStage);
            LocalPlayer player = Minecraft.getInstance().player;
            this.vSpace(5);
            for (int stageIdx = 0; stageIdx <= limit; ++stageIdx) {
                EchoStage stage = stages.get(stageIdx);
                MutableComponent title = Component.empty().withColor(Color4I.LIGHT_GREEN.rgb()).append(stage.title());
                CollapsibleSectionTitle titleWidget = new CollapsibleSectionTitle((Component)title, stageIdx);
                this.add((Widget)titleWidget);
                this.jumpPointWidgets.add((Widget)titleWidget);
                boolean collapsed = PersistedClientData.get().isStageCollapsed((Echo)echo, stageIdx);
                if (!collapsed) {
                    ArrayList loreLines = new ArrayList();
                    stage.lore().forEach(entry -> StageEntryRenderers.get(entry).ifPresent(r -> r.addWidgets(loreLines::add, (BaseStageEntry)entry, this)));
                    this.addAll(loreLines);
                    this.vSpace(5);
                }
                if (stageIdx == limit && stageIdx < stages.size() && !allCompleted) {
                    if (FTBEchoes.stageProvider().has((Player)player, stage.requiredGameStage())) {
                        if (!collapsed) {
                            this.add((Widget)new BorderedTextField(this).setText(stage.ready()));
                        }
                        this.add((Widget)new CompleteStageButton(this, (Echo)echo, stageIdx));
                    } else {
                        this.add((Widget)new BorderedTextField(this).setText(stage.notReady()));
                    }
                }
                if (stageIdx < currentStage) {
                    Component txt = stage.completed().orElse((Component)Component.translatable((String)"ftbechoes.gui.stage_completed"));
                    this.add((Widget)new TextField((Panel)this).setText((Component)Component.empty().withStyle(ChatFormatting.GREEN).append(txt)));
                    if (stage.completionReward().isPresent() && !stage.completionReward().get().autoclaim() && !ClientProgress.get().isRewardClaimed(echo.id(), (Player)player, stageIdx)) {
                        this.add((Widget)new ClaimRewardButton(this, (Echo)echo, stageIdx, stage.completionReward().get()));
                    }
                }
                if (stageIdx >= limit) continue;
                this.add(new HorizontalLineWidget(this, 0.85f));
            }
            if (allCompleted) {
                this.add(new HorizontalLineWidget(this, 0.85f));
                Component msg = echo.allComplete().orElse((Component)Component.translatable((String)"ftbechoes.gui.all_complete").withStyle(ChatFormatting.LIGHT_PURPLE));
                this.add((Widget)new TextField((Panel)this).setText(msg).setScale(1.25f).addFlags(4));
            }
            this.vSpace(10);
        });
    }

    public void alignWidgets() {
        this.widgets.forEach(w -> {
            int xPos = w instanceof CollapsibleSectionTitle ? 5 : 15;
            int xWid = this.width - (w instanceof CollapsibleSectionTitle ? 10 : 20);
            w.setX(w instanceof CollapsibleSectionTitle ? 5 : 15);
            Widget widget = w;
            Objects.requireNonNull(widget);
            Widget selector0$temp = widget;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageButton.class, TextField.class, BorderedTextField.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    ImageButton im = (ImageButton)selector0$temp;
                    int imgX = switch (im.getAlignment()) {
                        default -> throw new MatchException(null, null);
                        case ImageEntry.Alignment.LEFT -> xPos;
                        case ImageEntry.Alignment.CENTER -> xPos + (xWid - im.getWidth()) / 2;
                        case ImageEntry.Alignment.RIGHT -> xPos + xWid - im.getWidth() - 5;
                    };
                    im.setX(imgX);
                    break;
                }
                case 1: {
                    TextField t = (TextField)selector0$temp;
                    t.setWidth(xWid);
                    t.setMinWidth(xWid);
                    t.setMaxWidth(xWid);
                    t.reflow();
                    break;
                }
                case 2: {
                    BorderedTextField borderedTextField = (BorderedTextField)selector0$temp;
                    w.setWidth(xWid);
                    borderedTextField.alignWidgets();
                    break;
                }
            }
        });
        this.setHeight(this.align((WidgetLayout)new WidgetLayout.Vertical(0, 2, 0)) + 12);
    }

    public double getScrollPos(int stageIdx) {
        if (stageIdx >= 0 && stageIdx < this.jumpPointWidgets.size()) {
            return this.jumpPointWidgets.get(stageIdx).getPosY() - 2;
        }
        return 0.0;
    }

    public boolean isCollapsed(int stageIdx) {
        return this.getEcho().map(e -> PersistedClientData.get().isStageCollapsed((Echo)e, stageIdx)).orElse(false);
    }

    public void setCollapsed(int stageIdx, boolean collapsed) {
        this.getEcho().ifPresent(echo -> {
            if (PersistedClientData.get().setStageCollapsed((Echo)echo, stageIdx, collapsed)) {
                this.refreshWidgets();
            }
        });
    }

    public void setAllCollapsed(boolean collapse) {
        this.getEcho().ifPresent(echo -> {
            for (int i = 0; i < echo.stages().size(); ++i) {
                PersistedClientData.get().setStageCollapsed((Echo)echo, i, collapse);
            }
            this.refreshWidgets();
        });
    }

    private class CollapsibleSectionTitle
    extends SimpleTextButton {
        private final int stageIdx;

        public CollapsibleSectionTitle(Component title, int stageIdx) {
            super((Panel)LorePanel.this, title, (Icon)Icon.empty());
            this.setSize(this.getGui().getTheme().getStringWidth((FormattedText)title) + 25, this.getGui().getTheme().getFontHeight() + 7);
            this.stageIdx = stageIdx;
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void onClicked(MouseButton mouseButton) {
            this.playClickSound();
            Echo echo = LorePanel.this.getEcho().orElseThrow();
            PersistedClientData pcd = PersistedClientData.get();
            pcd.setStageCollapsed(echo, this.stageIdx, !pcd.isStageCollapsed(echo, this.stageIdx));
            LorePanel.this.refreshWidgets();
        }

        public Component getTitle() {
            MutableComponent arrow = Component.literal((String)(PersistedClientData.get().isStageCollapsed(LorePanel.this.getEcho().orElseThrow(), this.stageIdx) ? "\u25b6 " : "\u25bc "));
            return arrow.append(super.getTitle());
        }
    }

    private static class BorderedTextField
    extends Panel {
        private static final Icon TASKS_ICON = Icon.getIcon((ResourceLocation)Textures.TASKS);
        private final TextField textField = new TextField((Panel)this);
        private final int padding = 4;

        public BorderedTextField(Panel parent) {
            super(parent);
        }

        public void addWidgets() {
            this.add((Widget)this.textField);
        }

        public void alignWidgets() {
            int textwidth = this.width - 8 - 16;
            this.textField.setWidth(textwidth);
            this.textField.setMinWidth(textwidth);
            this.textField.setMaxWidth(textwidth);
            this.textField.reflow();
            this.setHeight(Math.max(20, this.textField.height + 8));
            this.textField.setPos(24, (this.height - this.textField.height) / 2);
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)theme.getContentColor(WidgetType.NORMAL).withAlpha(80), (boolean)false);
            TASKS_ICON.draw(graphics, x + 4, y + (this.height - 16) / 2, 16, 16);
            super.draw(graphics, theme, x, y, w, h);
        }

        public BorderedTextField setText(Component text) {
            this.textField.setText(text);
            return this;
        }
    }
}

