/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui.widget;

import dev.ftb.mods.ftbechoes.client.gui.EchoSoundClipHandler;
import dev.ftb.mods.ftbechoes.client.gui.Textures;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class AudioButton
extends SimpleTextButton {
    private static final Icon INACTIVE = Icon.getIcon((ResourceLocation)Textures.SPEAKER);
    private static final Icon INACTIVE_MISSING = Icon.getIcon((ResourceLocation)Textures.SPEAKER).combineWith(Icons.CANCEL.withColor(Color4I.WHITE.withAlpha(128)));
    private static final Icon ACTIVE = Icon.getIcon((ResourceLocation)Textures.SPEAKER_ACTIVE);
    private final SoundEvent sound;
    private final ResourceLocation location;

    public AudioButton(Panel panel, Component text, ResourceLocation location) {
        super(panel, text, INACTIVE);
        this.location = location;
        this.sound = this.findSound(location);
    }

    private SoundEvent findSound(ResourceLocation location) {
        String locale = Minecraft.getInstance().getLanguageManager().getSelected();
        ResourceLocation loc1 = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(locale + "/" + location.getPath()));
        ResourceLocation loc2 = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("en_us/" + location.getPath()));
        return BuiltInRegistries.SOUND_EVENT.getOptional(loc1).or(() -> BuiltInRegistries.SOUND_EVENT.getOptional(loc2)).or(() -> BuiltInRegistries.SOUND_EVENT.getOptional(location)).orElse(SoundEvents.EMPTY);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawPanelBackground(graphics, x + 2, y + 3, w - 4, h - 6);
        GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)(x + 1), (int)(y + 2), (int)(w - 2), (int)(h - 4), (Color4I)theme.getContentColor(WidgetType.DISABLED), (boolean)true);
    }

    public void onClicked(MouseButton mouseButton) {
        if (this.sound != SoundEvents.EMPTY) {
            if (EchoSoundClipHandler.INSTANCE.isPlayingSound(this.sound)) {
                EchoSoundClipHandler.INSTANCE.stopPlayingSound();
            } else {
                EchoSoundClipHandler.INSTANCE.startPlayingSound(this.sound);
            }
        }
    }

    public void tick() {
        this.setIcon(this.sound == SoundEvents.EMPTY ? INACTIVE_MISSING : (EchoSoundClipHandler.INSTANCE.isPlayingSound(this.sound) ? ACTIVE : INACTIVE));
    }

    public void addMouseOverText(TooltipList list) {
        if (this.sound == SoundEvents.EMPTY) {
            list.add((Component)Component.literal((String)("missing sound event: " + String.valueOf(this.location))));
        }
    }
}

