/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.ftb.mods.ftbechoes.block.entity.EchoProjectorBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;

public class EchoProjectorRenderer
implements BlockEntityRenderer<EchoProjectorBlockEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/villager.png");
    private final VillagerModel<Villager> model;

    public EchoProjectorRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new VillagerModel(ctx.bakeLayer(ModelLayers.VILLAGER));
    }

    public void render(EchoProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getEchoId() == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 2.02, 0.5);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f + Minecraft.getInstance().gameRenderer.getMainCamera().getYRot()));
        VertexConsumer builder = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TEXTURE));
        this.model.renderToBuffer(poseStack, builder, 0xF000F0, packedOverlay, -1869545473);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(EchoProjectorBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).setMaxY((double)(blockEntity.getBlockPos().getY() + 3));
    }
}

