/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.client.ShopSummary;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.net.SyncEchoesMessage;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbechoes.shopping.ShopDataCache;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class EchoManager {
    private static EchoManager clientInstance;
    private static EchoManager serverInstance;
    private final Map<ResourceLocation, Echo> echoes = new ConcurrentHashMap<ResourceLocation, Echo>();
    private final ShopDataCache shoppingCache = new ShopDataCache(this);

    public static void initClient() {
        assert (serverInstance == null);
        if (clientInstance == null) {
            clientInstance = new EchoManager();
        }
    }

    public static void shutdownClient() {
        if (clientInstance != null) {
            clientInstance.clear();
        }
        clientInstance = null;
    }

    public static void initServer() {
        assert (clientInstance == null);
        if (serverInstance == null) {
            serverInstance = new EchoManager();
        }
    }

    public static void shutdownServer() {
        if (serverInstance != null) {
            serverInstance.clear();
        }
        serverInstance = null;
    }

    public static EchoManager getInstance() {
        return Objects.requireNonNullElse(clientInstance, serverInstance);
    }

    public static EchoManager getClientInstance() {
        return clientInstance;
    }

    public static EchoManager getServerInstance() {
        return serverInstance;
    }

    public Collection<Echo> getEchoes() {
        return this.echoes.values();
    }

    public Optional<Echo> getEcho(ResourceLocation id) {
        return Optional.ofNullable(this.echoes.get(id));
    }

    public boolean isKnownEcho(ResourceLocation id) {
        return this.echoes.containsKey(id);
    }

    public void syncFromServer(Collection<Echo> echoes) {
        assert (this == clientInstance);
        this.clear();
        echoes.forEach(echo -> this.echoes.put(echo.id(), (Echo)echo));
        ShopSummary.INSTANCE.buildSummary();
        FTBEchoes.LOGGER.debug("{} echoes sync'd from server", (Object)echoes.size());
    }

    public void syncToClient(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new SyncEchoesMessage(this.getEchoes()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Optional<ShopDataCache.ShoppingEntry> getShoppingEntry(ShoppingKey key) {
        return Optional.ofNullable(this.shoppingCache.find(key));
    }

    public Optional<ShopData> getShopData(ShoppingKey key) {
        return this.getShoppingEntry(key).map(ShopDataCache.ShoppingEntry::data);
    }

    public void clear() {
        this.echoes.clear();
        this.shoppingCache.clear();
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        private final RegistryAccess registryAccess;

        public ReloadListener(RegistryAccess registryAccess) {
            super(GSON, "echo_definitions");
            this.registryAccess = registryAccess;
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            EchoManager.initServer();
            EchoManager.getServerInstance().clear();
            map.forEach((id, json) -> Echo.fromJson(json, this.registryAccess).ifPresent(echo -> EchoManager.getServerInstance().echoes.put((ResourceLocation)id, (Echo)echo)));
            FTBEchoes.LOGGER.info("loaded {} echo definitions", (Object)EchoManager.getServerInstance().echoes.size());
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncEchoesMessage(EchoManager.getServerInstance().getEchoes()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

