/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.CommandInfo;
import dev.ftb.mods.ftbechoes.util.EchoCodecs;
import dev.ftb.mods.ftbechoes.util.MiscUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public record StageCompletionReward(List<ItemStack> stacks, int exp, int currency, Optional<CommandInfo> command, List<Component> description, boolean autoclaim) {
    public static final Codec<StageCompletionReward> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EchoCodecs.ITEM_OR_ITEMS_CODEC.optionalFieldOf("item", List.of()).forGetter(StageCompletionReward::stacks), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("experience", (Object)0).forGetter(StageCompletionReward::exp), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("currency", (Object)0).forGetter(StageCompletionReward::currency), (App)CommandInfo.CODEC.optionalFieldOf("command").forGetter(StageCompletionReward::command), (App)EchoCodecs.COMPONENT_OR_LIST.optionalFieldOf("description", List.of()).forGetter(StageCompletionReward::description), (App)Codec.BOOL.optionalFieldOf("autoclaim", (Object)true).forGetter(StageCompletionReward::autoclaim)).apply((Applicative)builder, StageCompletionReward::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StageCompletionReward> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), StageCompletionReward::stacks, (StreamCodec)ByteBufCodecs.VAR_INT, StageCompletionReward::exp, (StreamCodec)ByteBufCodecs.VAR_INT, StageCompletionReward::currency, (StreamCodec)ByteBufCodecs.optional(CommandInfo.STREAM_CODEC), StageCompletionReward::command, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), StageCompletionReward::description, (StreamCodec)ByteBufCodecs.BOOL, StageCompletionReward::autoclaim, StageCompletionReward::new);

    public void giveToPlayer(ServerPlayer player) {
        this.stacks.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.copy()));
        if (this.exp > 0) {
            player.giveExperiencePoints(this.exp);
        }
        if (this.currency > 0) {
            FTBEchoes.currencyProvider().giveCurrency((Player)player, this.currency);
        }
        this.command.ifPresent(cmdInfo -> cmdInfo.runForPlayer(player));
    }

    public void addTooltip(Consumer<Component> consumer) {
        this.description.forEach(consumer);
        for (ItemStack stack : this.stacks) {
            consumer.accept((Component)StageCompletionReward.bullet().append(stack.getCount() + " x ").append(stack.getHoverName()));
        }
        if (this.exp > 0) {
            consumer.accept((Component)StageCompletionReward.bullet().append(this.exp + " XP"));
        }
        if (this.currency > 0) {
            consumer.accept((Component)StageCompletionReward.bullet().append(MiscUtil.formatCost(this.currency)));
        }
        this.command.ifPresent(cmd -> cmd.description().forEach(line -> consumer.accept((Component)StageCompletionReward.bullet().append(line))));
    }

    private static MutableComponent bullet() {
        return Component.literal((String)"\u2022 ").withStyle(ChatFormatting.AQUA);
    }
}

