/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo.progress;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;

public final class PerEchoProgress {
    private static final Codec<Map<UUID, Set<Integer>>> REWARDS_CLAIMED = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT.listOf().xmap(HashSet::new, ArrayList::new));
    private static final Codec<PerEchoProgress> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.xmap(MutableInt::new, MutableInt::getValue).fieldOf("current_stage").forGetter(p -> p.currentStage), (App)REWARDS_CLAIMED.fieldOf("rewards_claimed").forGetter(p -> p.claimedRewards)).apply((Applicative)builder, PerEchoProgress::new));
    public static final Codec<PerEchoProgress> CODEC = RAW_CODEC.xmap(in -> new PerEchoProgress(in.currentStage, new HashMap<UUID, Set<Integer>>(in.claimedRewards)), Function.identity());
    public static final StreamCodec<FriendlyByteBuf, PerEchoProgress> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(MutableInt::new, MutableInt::getValue), p -> p.currentStage, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.collection(HashSet::new))), p -> p.claimedRewards, PerEchoProgress::new);
    private final MutableInt currentStage;
    private final Map<UUID, Set<Integer>> claimedRewards;

    public PerEchoProgress(MutableInt currentStage, Map<UUID, Set<Integer>> claimedRewards) {
        this.currentStage = currentStage;
        this.claimedRewards = claimedRewards;
    }

    public static PerEchoProgress createEmptyProgress() {
        return new PerEchoProgress(new MutableInt(0), new HashMap<UUID, Set<Integer>>());
    }

    public int getCurrentStage() {
        return this.currentStage.intValue();
    }

    void setCurrentStage(int stage) {
        this.currentStage.setValue(stage);
    }

    public boolean isRewardClaimed(Player player, int stage) {
        return this.claimedRewards.getOrDefault(player.getUUID(), Set.of()).contains(stage);
    }

    boolean setRewardClaimed(UUID playerId, int stage, boolean claimed) {
        Set s = this.claimedRewards.computeIfAbsent(playerId, k -> new HashSet());
        return claimed ? s.add(stage) : s.remove(stage);
    }

    boolean clearRewards(UUID playerId) {
        Set s = this.claimedRewards.computeIfAbsent(playerId, k -> new HashSet());
        boolean hadAnyRewards = !s.isEmpty();
        s.clear();
        return hadAnyRewards;
    }

    void completeStage() {
        this.currentStage.increment();
    }

    public PerEchoProgress forSyncToPlayer(ServerPlayer player) {
        UUID playerId = player.getUUID();
        Map<UUID, Set<Integer>> rewards = Map.of(playerId, this.claimedRewards.getOrDefault(playerId, Set.of()));
        return new PerEchoProgress(new MutableInt((Number)this.currentStage), rewards);
    }

    public Map<UUID, Set<Integer>> claimedRewards() {
        return this.claimedRewards;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PerEchoProgress that = (PerEchoProgress)obj;
        return Objects.equals(this.currentStage, that.currentStage) && Objects.equals(this.claimedRewards, that.claimedRewards);
    }

    public int hashCode() {
        return Objects.hash(this.currentStage, this.claimedRewards);
    }

    public String toString() {
        return "PerEchoProgress[currentStage=" + String.valueOf(this.currentStage) + ", claimedRewards=" + String.valueOf(this.claimedRewards) + "]";
    }
}

