/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.shopping;

import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ShopDataCache {
    private final Map<ShoppingKey, ShoppingEntry> map = new HashMap<ShoppingKey, ShoppingEntry>();
    private final EchoManager echoManager;

    public ShopDataCache(EchoManager echoManager) {
        this.echoManager = echoManager;
    }

    @Nullable
    public ShoppingEntry find(ShoppingKey key) {
        return this.map.computeIfAbsent(key, k -> this.echoManager.getEcho(key.echoId()).map(echo -> ShopDataCache.findEntry(echo, key.name())).orElse(null));
    }

    @Nullable
    private static ShoppingEntry findEntry(Echo echo, String name) {
        List<EchoStage> stages = echo.stages();
        for (int stageIdx = 0; stageIdx < stages.size(); ++stageIdx) {
            for (ShopData d : stages.get(stageIdx).shopUnlocked()) {
                if (!d.name().equals(name)) continue;
                return new ShoppingEntry(d, stageIdx);
            }
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    public record ShoppingEntry(ShopData data, int stageIdx) {
    }
}

