/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.shopping;

import com.google.common.collect.Maps;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ShoppingBasket {
    public static final StreamCodec<FriendlyByteBuf, ShoppingBasket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, ShoppingKey.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), b -> b.orders, ShoppingBasket::new);
    private final Object2IntMap<ShoppingKey> orders;
    private int totalCost = 0;
    public static final ShoppingBasket CLIENT_INSTANCE = new ShoppingBasket(Map.of());

    private ShoppingBasket(Map<ShoppingKey, Integer> map) {
        this.orders = new Object2IntOpenHashMap(map);
        this.recalc();
    }

    public void adjust(ShoppingKey key, int count, int max) {
        int newCount = this.orders.getOrDefault((Object)key, 0) + count;
        if (newCount <= 0) {
            this.orders.removeInt((Object)key);
        } else {
            this.orders.put((Object)key, Math.min(max, newCount));
        }
        this.recalc();
    }

    public int get(ShoppingKey key) {
        return this.orders.getOrDefault((Object)key, 0);
    }

    public boolean hasContents() {
        return !this.orders.isEmpty();
    }

    public void clear() {
        this.orders.clear();
        this.recalc();
    }

    public void forEach(BiConsumer<ShoppingKey, Integer> consumer) {
        this.orders.forEach(consumer);
    }

    public int getTotalCost() {
        return this.totalCost;
    }

    public void giveTo(ServerPlayer player) {
        EchoManager mgr = EchoManager.getServerInstance();
        this.orders.forEach((key, nOrders) -> mgr.getShopData((ShoppingKey)key).ifPresent(data -> data.giveTo((ShoppingKey)key, player, (int)nOrders)));
    }

    public ShoppingBasket validate(ServerPlayer player) {
        HashMap<ShoppingKey, Integer> map = new HashMap<ShoppingKey, Integer>();
        if (player.getServer() != null) {
            TeamProgressManager.get(player.getServer()).getProgress(player).ifPresent(progress -> {
                EchoManager mgr = EchoManager.getServerInstance();
                this.orders.forEach((key, amount) -> mgr.getShoppingEntry((ShoppingKey)key).ifPresent(entry -> {
                    boolean stockAvailable = entry.data().maxClaims().isEmpty() || progress.getRemainingShopStock((Player)player, (ShoppingKey)key, entry.data()) >= amount;
                    int currentStage = progress.getCurrentStage(key.echoId());
                    if (stockAvailable && currentStage >= entry.stageIdx() && currentStage <= entry.data().maxStage()) {
                        map.put((ShoppingKey)key, (Integer)amount);
                    }
                }));
            });
        }
        return new ShoppingBasket(map);
    }

    private void recalc() {
        this.totalCost = 0;
        EchoManager mgr = this == CLIENT_INSTANCE ? EchoManager.getClientInstance() : EchoManager.getServerInstance();
        this.orders.forEach((key, nOrders) -> this.totalCost += mgr.getShopData((ShoppingKey)key).map(data -> data.cost() * nOrders).orElse(0).intValue());
    }
}

