/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui.resource;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.resource.EntityFaceResource;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.resource.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class SelectEntityFaceScreen
extends ResourceSelectorScreen<EntityType<?>> {
    private static final SearchModeIndex<ResourceSearchMode<EntityType<?>>> KNOWN_MODES = (SearchModeIndex)Util.make(new SearchModeIndex(), idx -> idx.appendMode(ResourceSearchMode.ENTITY_FACES));

    public SelectEntityFaceScreen(ResourceConfigValue<EntityType<?>> config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, @Nullable SelectableResource<EntityType<?>> resource) {
        return new EntityFaceButton(this, panel, Objects.requireNonNullElse(resource, EntityFaceResource.NONE));
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<EntityType<?>>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    private class EntityFaceButton
    extends ResourceSelectorScreen.ResourceButton {
        protected EntityFaceButton(SelectEntityFaceScreen selectEntityFaceScreen, Panel panel, SelectableResource<EntityType<?>> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            EntityFaceResource r;
            SelectableResource selectableResource = this.selectable;
            return selectableResource instanceof EntityFaceResource && searchTerms.match((r = (EntityFaceResource)selectableResource).getLocation(), r.getLocation().toString(), key -> ((EntityType)this.getResource()).is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)key)));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.selectable == EntityFaceResource.NONE) {
                list.add((Component)Component.translatable((String)"gui.none"));
            } else {
                list.add(((EntityType)this.getResource()).getDescription());
                SelectableResource selectableResource = this.selectable;
                if (selectableResource instanceof EntityFaceResource) {
                    EntityFaceResource r = (EntityFaceResource)selectableResource;
                    if (((Boolean)FTBLibraryClientConfig.ENTITY_MODNAME.get()).booleanValue()) {
                        ModUtils.getModName(r.getLocation().getNamespace()).ifPresent(name -> list.add((Component)Component.literal((String)name).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                    }
                }
            }
        }
    }
}

