/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config;

import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.packcompanion.config.values.ChunkPosCustomYHashValue;
import dev.ftb.packcompanion.config.values.GameRuleMapping;
import dev.ftb.packcompanion.config.values.SparseStructuresConfig;
import dev.ftb.packcompanion.config.values.SparseStructuresValue;
import dev.ftb.packcompanion.core.utils.CustomYConfig;
import java.util.ArrayList;
import java.util.Map;

public interface PCCommonConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbpc-common");
    public static final BooleanValue BREAK_LIGHT_SOURCES_NEAR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("break_light_sources_near_spawners", false).comment(new String[]{"When enabled, light sources near spawners will be broken to allow for mob spawning."});
    public static final BooleanValue IGNORE_LIGHT_LEVEL_FOR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("ignore_light_level_for_spawners", false).comment(new String[]{"When enabled, the light level around spawners will be ignored for mob spawning."});
    public static final BooleanValue REMOVE_CONCENTRIC_RING_PLACEMENT_BIAS = (BooleanValue)CONFIG.addBoolean("remove_concentric_ring_placement_bias", false).comment(new String[]{"When enabled, the random bias applied to concentric ring distances is removed"});
    public static final SparseStructuresValue SPARSE_STRUCTURES = (SparseStructuresValue)CONFIG.add((BaseValue)new SparseStructuresValue(CONFIG, "sparse_structures", SparseStructuresConfig.DEFAULT));
    public static final SNBTConfig SHADERS_NOTICE = CONFIG.addGroup("shaders_notice");
    public static final StringValue SHADER_PACK_TO_USE = (StringValue)SHADERS_NOTICE.addString("shader_pack_to_use", "").comment(new String[]{"The shader pack to use when enabling shaders. Leave empty to use the default shader pack / first available shader pack in the list"});
    public static final BooleanValue SHOW_ON_START = (BooleanValue)SHADERS_NOTICE.addBoolean("show_on_start", false).comment(new String[]{"When enabled, the shaders notice will be shown on world start if shaders are included in the pack."});
    public static final SNBTConfig INTEGRATIONS = CONFIG.addGroup("integrations");
    public static final SNBTConfig FTB_CHUNKS = (SNBTConfig)INTEGRATIONS.addGroup("ftb_chunks").comment(new String[]{"Configuration options for the FTB Chunks mod integration. Only effective if FTB Chunks is installed."});
    public static final ChunkPosCustomYHashValue CUSTOM_Y_LEVEL_CHUNK_POSITIONS = (ChunkPosCustomYHashValue)FTB_CHUNKS.add((BaseValue)((ChunkPosCustomYHashValue)new ChunkPosCustomYHashValue(FTB_CHUNKS, "custom_y_level_chunk_positions", new ArrayList<CustomYConfig>()).comment(new String[]{"Custom min-y level list for specific block locations within a range from the center, per dimension."})));
    public static final SNBTConfig FORCED_GAME_RULES = CONFIG.addGroup("forced-game-rules");
    public static final GameRuleMapping GAME_RULE_MAPPING = (GameRuleMapping)FORCED_GAME_RULES.add((BaseValue)((GameRuleMapping)new GameRuleMapping(FORCED_GAME_RULES, "rules", Map.of()).comment(new String[]{"Game rules that are forced on the server. The keys must be valid game rule IDs."})));

    public static void init() {
        ConfigManager.getInstance().registerServerConfig(CONFIG, "ftbpc.common", true);
    }
}

