/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad;

import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.packcompanion.features.actionpad.PadAction;
import dev.ftb.packcompanion.integrations.teams.TeamsIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PadActions {
    private static PadActions INSTANCE;
    private static final Logger LOGGER;
    private static final List<PadAction> defaultDestination;
    private final List<PadAction> actions = new ArrayList<PadAction>();
    private final Path destinationsFile = FMLPaths.CONFIGDIR.get().resolve("ftbpc_pad_actions.snbt");

    public static PadActions get() {
        if (INSTANCE == null) {
            INSTANCE = new PadActions();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void load() {
        try {
            SNBTCompoundTag compoundTag = SNBT.tryRead((Path)this.destinationsFile);
            if (compoundTag != null) {
                this.actions.clear();
                PadAction.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getList("actions", 10)).result().ifPresentOrElse(this.actions::addAll, () -> this.actions.addAll(defaultDestination));
            }
        }
        catch (Exception error) {
            LOGGER.error("Failed to load action pad actions, using default", (Throwable)error);
        }
        finally {
            if (this.actions.isEmpty()) {
                this.actions.addAll(defaultDestination);
                this.writeDefault();
            }
        }
    }

    public void writeDefault() {
        ListTag items = PadAction.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, defaultDestination).result().map(nbt -> (ListTag)nbt).orElse(new ListTag());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("actions", (Tag)items);
        try {
            SNBT.tryWrite((Path)this.destinationsFile, (CompoundTag)compoundTag);
        }
        catch (Exception error) {
            LOGGER.error("Failed to write default action pad actions", (Throwable)error);
        }
    }

    public List<PadAction> getUnlockedActions(ServerPlayer player) {
        ArrayList<PadAction> unlocked = new ArrayList<PadAction>();
        for (PadAction action : this.actions) {
            if (action.unlockedAt().isEmpty() && action.teamUnlockedAt().isEmpty()) {
                unlocked.add(action);
                continue;
            }
            if (action.teamUnlockedAt().isPresent() && TeamsIntegration.get().hasStage(player, action.teamUnlockedAt().get())) {
                unlocked.add(action);
                continue;
            }
            if (!action.unlockedAt().isPresent() || !StageHelper.getInstance().getProvider().has((Player)player, action.unlockedAt().get())) continue;
            unlocked.add(action);
        }
        return unlocked;
    }

    public Optional<PadAction> getAction(Player player, String actionName) {
        return this.getUnlockedActions((ServerPlayer)player).stream().filter(a -> a.name().equals(actionName)).findFirst();
    }

    static {
        LOGGER = LoggerFactory.getLogger(PadActions.class);
        defaultDestination = List.of(new PadAction("ftbpackcompanion.spawn", Icons.GLOBE, Optional.empty(), Optional.empty(), Optional.of(new PadAction.CommandAction("/spawn", 2, false)), Optional.empty(), true), new PadAction("ftbpackcompanion.home", Icons.COMPASS, Optional.empty(), Optional.empty(), Optional.of(new PadAction.CommandAction("/home", 2, false)), Optional.empty(), true));
    }
}

