/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad.net;

import dev.ftb.packcompanion.PackCompanion;
import dev.ftb.packcompanion.features.actionpad.ActionPadFeature;
import dev.ftb.packcompanion.features.actionpad.ActionPadItem;
import dev.ftb.packcompanion.features.actionpad.PadActions;
import dev.ftb.packcompanion.features.actionpad.net.OpenActionPadPacket;
import dev.ftb.packcompanion.integrations.InventorySearcher;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public enum TryOpenActionPadFromItemPacket implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<TryOpenActionPadFromItemPacket> TYPE;
    public static final StreamCodec<FriendlyByteBuf, TryOpenActionPadFromItemPacket> STREAM_CODEC;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TryOpenActionPadFromItemPacket ignored, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            boolean hasPlayersOnline = Optional.ofNullable(player.getServer()).map(e -> e.getPlayerList().getPlayerCount() > 1).orElse(false);
            if (!FMLEnvironment.production) {
                hasPlayersOnline = true;
            }
            for (ItemStack itemStack : player.getInventory().items) {
                if (!(itemStack.getItem() instanceof ActionPadItem)) continue;
                TryOpenActionPadFromItemPacket.sendOpenPacket(player, hasPlayersOnline);
                return;
            }
            if (InventorySearcher.INSTANCE.containsItem(player, (Item)ActionPadFeature.ACTION_PAD.get())) {
                TryOpenActionPadFromItemPacket.sendOpenPacket(player, hasPlayersOnline);
            }
        });
    }

    private static void sendOpenPacket(Player player, boolean playersOnline) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenActionPadPacket(PadActions.get().getUnlockedActions((ServerPlayer)player), playersOnline), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    static {
        TYPE = new CustomPacketPayload.Type(PackCompanion.id("try_open_action_pad_from_item"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

