/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.integrations.chunks;

import dev.ftb.mods.ftbchunks.api.event.CustomMinYEvent;
import dev.ftb.packcompanion.config.PCCommonConfig;
import dev.ftb.packcompanion.core.utils.CustomYConfig;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.resources.ResourceLocation;

public class FTBChunksIntegration {
    public static void init() {
        CustomMinYEvent.REGISTER.register(registry -> registry.register((level, pos) -> {
            List customYLevelChunkPositions = (List)PCCommonConfig.CUSTOM_Y_LEVEL_CHUNK_POSITIONS.get();
            if (customYLevelChunkPositions.isEmpty()) {
                return OptionalInt.empty();
            }
            ResourceLocation currentDimension = level.dimension().location();
            int x = pos.getX();
            int z = pos.getZ();
            for (CustomYConfig customYConfig : customYLevelChunkPositions) {
                if (!FTBChunksIntegration.matchesDimension(customYConfig.equalityCheck(), customYConfig.dimension(), currentDimension)) continue;
                int range = customYConfig.range();
                int configX = customYConfig.x();
                int configZ = customYConfig.z();
                int dx = x - configX;
                int dz = z - configZ;
                if (!(customYConfig.asRadius() ? dx * dx + dz * dz <= range * range : Math.abs(dx) <= range && Math.abs(dz) <= range)) continue;
                return OptionalInt.of(customYConfig.minY());
            }
            return OptionalInt.empty();
        }));
    }

    private static boolean matchesDimension(CustomYConfig.DimensionEqualityCheck equalityCheck, String configDimension, ResourceLocation dimension) {
        String dimensionStr = dimension.toString();
        return switch (equalityCheck) {
            default -> throw new MatchException(null, null);
            case CustomYConfig.DimensionEqualityCheck.STARTS_WITH -> dimensionStr.startsWith(configDimension);
            case CustomYConfig.DimensionEqualityCheck.EXACT_MATCH -> dimensionStr.equals(configDimension);
            case CustomYConfig.DimensionEqualityCheck.ENDS_WITH -> dimensionStr.endsWith(configDimension);
        };
    }
}

