/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings;

import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlockEntity;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.items.FluidCapsuleItem;
import dev.ftb.mods.ftbstuffnthings.items.WaterBowlItem;
import dev.ftb.mods.ftbstuffnthings.network.SyncLootSummaryPacket;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ContentRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.CriterionTriggerRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.LootSummaryCollection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.slf4j.Logger;

@Mod(value="ftbstuff")
public class FTBStuffNThings {
    public static final String MODID = "ftbstuff";
    public static final Logger LOGGER = LogUtils.getLogger();

    public FTBStuffNThings(IEventBus modEventBus) {
        ConfigManager.getInstance().registerServerConfig(Config.CONFIG, MODID, false);
        BlocksRegistry.init(modEventBus);
        ItemsRegistry.init(modEventBus);
        BlockEntitiesRegistry.init(modEventBus);
        RecipesRegistry.init(modEventBus);
        ContentRegistry.init(modEventBus);
        ComponentsRegistry.init(modEventBus);
        CriterionTriggerRegistry.init(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::onPlayerJoin);
    }

    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FTBStuffNThings.syncLootSummaries(serverPlayer);
            CriterionTriggerRegistry.FTBSTUFF_ROOT.get().trigger(serverPlayer);
        }
    }

    public static void syncLootSummaries(ServerPlayer serverPlayer) {
        LootSummaryCollection lsc = new LootSummaryCollection();
        Config.getStrainerLootTable().ifPresent(lootTableId -> BlocksRegistry.waterStrainers().forEach(b -> lsc.addEntry((ResourceKey<Block>)b.getKey(), (ResourceLocation)lootTableId, FTBStuffNThings.makeBlockParams(serverPlayer, ((WaterStrainerBlock)((Object)((Object)((Object)b.get())))).defaultBlockState()))));
        BlocksRegistry.BARRELS.forEach(b -> lsc.addEntry((ResourceKey<Block>)b.getKey(), FTBStuffNThings.blockLootTable((DeferredBlock<Block>)b), FTBStuffNThings.makeBlockParams(serverPlayer, ((Block)b.get()).defaultBlockState())));
        BlocksRegistry.CRATES.forEach(b -> lsc.addEntry((ResourceKey<Block>)b.getKey(), FTBStuffNThings.blockLootTable((DeferredBlock<Block>)b), FTBStuffNThings.makeBlockParams(serverPlayer, ((Block)b.get()).defaultBlockState())));
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncLootSummaryPacket(lsc), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static LootParams makeBlockParams(ServerPlayer serverPlayer, BlockState state) {
        return new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.ZERO).withParameter(LootContextParams.TOOL, (Object)Items.DIAMOND_PICKAXE.getDefaultInstance()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).create(LootContextParamSets.BLOCK);
    }

    private static ResourceLocation blockLootTable(DeferredBlock<Block> db) {
        return ResourceLocation.fromNamespaceAndPath((String)db.getId().getNamespace(), (String)("blocks/" + db.getId().getPath()));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntitiesRegistry.JAR.get(), (blockEntity, side) -> blockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntitiesRegistry.TEMPERED_JAR.get(), TemperedJarBlockEntity::getInputItemHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntitiesRegistry.TEMPERED_JAR.get(), TemperedJarBlockEntity::getFluidHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntitiesRegistry.WATER_STRAINER.get(), WaterStrainerBlockEntity::getItemHandler);
        List.of(BlockEntitiesRegistry.FUSING_MACHINE, BlockEntitiesRegistry.SUPER_COOLER).forEach(machine -> AbstractMachineBlockEntity.registerCapabilities(event, (BlockEntityType<? extends AbstractMachineBlockEntity>)((BlockEntityType)machine.get())));
        List.of(BlockEntitiesRegistry.OAK_SLUICE, BlockEntitiesRegistry.SPRUCE_SLUICE, BlockEntitiesRegistry.BIRCH_SLUICE, BlockEntitiesRegistry.JUNGLE_SLUICE, BlockEntitiesRegistry.ACACIA_SLUICE, BlockEntitiesRegistry.DARK_OAK_SLUICE, BlockEntitiesRegistry.MANGROVE_SLUICE, BlockEntitiesRegistry.CHERRY_SLUICE, BlockEntitiesRegistry.PALE_OAK_SLUICE, BlockEntitiesRegistry.CRIMSON_SLUICE, BlockEntitiesRegistry.WARPED_SLUICE, BlockEntitiesRegistry.BAMBOO_SLUICE, BlockEntitiesRegistry.IRON_SLUICE, BlockEntitiesRegistry.DIAMOND_SLUICE, BlockEntitiesRegistry.NETHERITE_SLUICE).forEach(sluice -> SluiceBlockEntity.registerCapabilities(event, (BlockEntityType<? extends AbstractMachineBlockEntity>)((BlockEntityType)sluice.get())));
        List.of(BlockEntitiesRegistry.IRON_HAMMER, BlockEntitiesRegistry.GOLD_HAMMER, BlockEntitiesRegistry.DIAMOND_HAMMER, BlockEntitiesRegistry.NETHERITE_HAMMER).forEach(hammer -> AutoHammerBlockEntity.registerCapabilities(event, (BlockEntityType<? extends AutoHammerBlockEntity>)((BlockEntityType)hammer.get())));
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidCapsuleItem.FluidHandler((ItemStack)stack), new ItemLike[]{ItemsRegistry.FLUID_CAPSULE});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new WaterBowlItem.WaterBowlFluidHandler((ItemStack)stack), new ItemLike[]{ItemsRegistry.WATER_BOWL});
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntitiesRegistry.WOODEN_BASIN.get(), (blockEntity, side) -> blockEntity.getFluidHandler());
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CacheReloadListener());
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static class CacheReloadListener
    implements PreparableReloadListener {
        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(RecipeCaches::clearAll, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0));
        }
    }
}

