/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.client.ClientUtil;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMachineBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    protected static BlockBehaviour.Properties defaultMachineProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.0f, 1.0f);
    }

    public AbstractMachineBlock(BlockBehaviour.Properties props) {
        super(props);
        BlockState state = (BlockState)this.getStateDefinition().any();
        if (this.isDirectional()) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        }
        if (state.hasProperty((Property)ACTIVE)) {
            state = (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        if (this.defaultBlockState().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    protected boolean hasActiveStateProperty() {
        return true;
    }

    protected boolean isDirectional() {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.isDirectional()) {
            builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        }
        if (this.hasActiveStateProperty()) {
            builder.add(new Property[]{ACTIVE});
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        if (this.isDirectional()) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (context.level() != null) {
            FluidStack fluidStack;
            int energy;
            if (context.level().isClientSide) {
                ClientUtil.maybeAddBlockTooltip(stack, tooltipComponents);
            }
            if ((energy = ((Integer)stack.getOrDefault(ComponentsRegistry.STORED_ENERGY, (Object)0)).intValue()) > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"ftbstuff.tooltip.energy", (Object[])new Object[]{energy}).withStyle(ChatFormatting.YELLOW));
            }
            if (!(fluidStack = ((SimpleFluidContent)stack.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy()).isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"ftbstuff.tooltip.fluid", (Object[])new Object[]{fluidStack.getAmount(), fluidStack.getHoverName()}).withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            AbstractMachineBlockEntity machine;
            IFluidHandler handler;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractMachineBlockEntity && (handler = (machine = (AbstractMachineBlockEntity)blockEntity).getFluidHandler(hitResult.getDirection())) != null && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)handler)) {
                return ItemInteractionResult.CONSUME;
            }
            if (blockEntity instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)blockEntity;
                player.openMenu(menuProvider, pos);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState arg2, BlockEntityType<T> arg3) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof AbstractMachineBlockEntity) {
                AbstractMachineBlockEntity tickable = (AbstractMachineBlockEntity)t;
                if (level1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level1;
                    tickable.tickServer(serverLevel);
                } else {
                    tickable.tickClient(level1);
                }
            }
        };
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractMachineBlockEntity) {
            AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)blockEntity;
            machine.dropItemContents();
        }
        super.onRemove(state, level, pos, newState, bl);
    }

    private static boolean doFluidInteraction(BlockEntity te, Direction face, Player player, InteractionHand hand, boolean isInserting) {
        ItemStack stack = player.getItemInHand(hand);
        return FluidUtil.getFluidHandler((ItemStack)stack).map(stackHandler -> {
            IFluidHandler handler = (IFluidHandler)te.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), te.getBlockState(), te, (Object)face);
            if (handler != null) {
                FluidActionResult result;
                if (stackHandler.getTanks() == 0) {
                    return false;
                }
                int capacity = stackHandler.getTankCapacity(0);
                PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.getInventory());
                FluidActionResult fluidActionResult = result = isInserting ? FluidUtil.tryEmptyContainerAndStow((ItemStack)player.getItemInHand(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.getItemInHand(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    player.setItemInHand(hand, result.getResult());
                    return true;
                }
                return false;
            }
            return false;
        }).orElse(false);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return this.isDirectional() ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) : state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.isDirectional() ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) : state;
    }
}

