/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlock;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingFluidTank;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMachineBlockEntity
extends BlockEntity
implements MenuProvider {
    public AbstractMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public ContainerData getContainerData() {
        return null;
    }

    @Nullable
    public IItemHandler getItemHandler() {
        return this.getItemHandler(null);
    }

    @Nullable
    public IFluidHandler getFluidHandler() {
        return this.getFluidHandler(null);
    }

    @Nullable
    public IEnergyStorage getEnergyHandler() {
        return this.getEnergyHandler(null);
    }

    @Nullable
    public abstract IItemHandler getItemHandler(@Nullable Direction var1);

    @Nullable
    public abstract IFluidHandler getFluidHandler(@Nullable Direction var1);

    @Nullable
    public abstract IEnergyStorage getEnergyHandler(@Nullable Direction var1);

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void syncFluidTank(boolean toGui) {
        IFluidHandler iFluidHandler = this.getFluidHandler();
        if (iFluidHandler instanceof EmittingFluidTank) {
            EmittingFluidTank tank = (EmittingFluidTank)iFluidHandler;
            if (toGui) {
                tank.syncToContainers(this);
            } else {
                tank.syncToTrackers(this);
            }
        }
    }

    public void tickClient(Level clientLevel) {
        this.getActiveParticle().ifPresent(particle -> {
            if (this.getBlockState().hasProperty((Property)AbstractMachineBlock.ACTIVE) && ((Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue() && clientLevel.random.nextInt(5) == 0) {
                Vec3 vec = Vec3.upFromBottomCenterOf((Vec3i)this.getBlockPos(), (double)1.05);
                clientLevel.addParticle(particle, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
            }
        });
    }

    protected Optional<ParticleOptions> getActiveParticle() {
        return Optional.of(ParticleTypes.SMOKE);
    }

    public abstract void tickServer(ServerLevel var1);

    public void dropItemContents() {
        IItemHandler handler = this.getItemHandler();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)handler.getStackInSlot(i));
            }
        }
    }

    protected final void setActive(boolean active) {
        boolean curActive;
        if (this.getBlockState().hasProperty((Property)AbstractMachineBlock.ACTIVE) && active != (curActive = ((Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ACTIVE)).booleanValue())) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AbstractMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 2);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractMachineBlockEntity> machine) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, machine, AbstractMachineBlockEntity::getItemHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, machine, AbstractMachineBlockEntity::getFluidHandler);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, machine, AbstractMachineBlockEntity::getEnergyHandler);
    }

    public void syncItemFromServer(ItemStack itemStack) {
    }

    public void syncFluidFromServer(FluidStack fluidStack) {
    }
}

