/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.dripper;

import dev.ftb.mods.ftbstuffnthings.blocks.dripper.DripperBlockEntity;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class DripperBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = VoxelShapeUtils.or(Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public DripperBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DripperBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DripperBlockEntity) {
            DripperBlockEntity dripper = (DripperBlockEntity)blockEntity;
            FluidTank tank = dripper.getTank();
            FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank);
            if (tank.getFluidAmount() == 0) {
                player.displayClientMessage((Component)Component.translatable((String)"ftblibrary.empty"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"ftblibrary.mb", (Object[])new Object[]{tank.getFluidAmount(), tank.getFluid().getHoverName()}), true);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            BlockState dripState;
            FluidStack fluid;
            DripperBlockEntity dripper;
            BlockEntity entity = level.getBlockEntity(pos);
            boolean foundParticle = false;
            if (entity instanceof DripperBlockEntity && !(dripper = (DripperBlockEntity)entity).getTank().isEmpty() && !(fluid = dripper.getTank().getFluid()).isEmpty() && (dripState = fluid.getFluid().defaultFluidState().createLegacyBlock()).getBlock() != Blocks.AIR) {
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, dripState), (double)pos.getX() + 0.5, (double)pos.getY() + 0.475, (double)pos.getZ() + 0.5, 0.0, -1.0, 0.0);
                foundParticle = true;
            }
            if (!foundParticle) {
                level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, be) -> {
            if (be instanceof DripperBlockEntity) {
                DripperBlockEntity dripper = (DripperBlockEntity)be;
                if (level1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level1;
                    dripper.serverTick(serverLevel);
                }
            }
        };
    }
}

