/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.sluice;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceProperties;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingEnergy;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingFluidTank;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SluiceRecipe;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.network.SendSluiceStartPacket;
import dev.ftb.mods.ftbstuffnthings.network.SyncDisplayItemPacket;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SluiceBlockEntity
extends AbstractMachineBlockEntity {
    private static final float BASE_PROCESSING_TIME = 60.0f;
    private final ItemStackHandler inputInventory = new SluiceItemHandler();
    private final EmittingEnergy energyStorage = new EmittingEnergy(100000, energy -> this.setChanged());
    private BlockCapabilityCache<IItemHandler, Direction> outputCache;
    private int processingProgress = 0;
    private int processingTime = 0;
    private boolean itemSyncNeeded;
    private boolean fluidSyncNeeded;
    private final FluidTank fluidTank = new SluiceFluidTank(this, 10000, tank -> {
        this.setChanged();
        this.fluidSyncNeeded = true;
    });
    private ItemStack overflow = ItemStack.EMPTY;

    public SluiceBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState blockState) {
        super(entity, pos, blockState);
    }

    @Override
    public void tickClient(Level clientLevel) {
        super.tickClient(clientLevel);
        if (this.processingTime > 0 && this.processingProgress++ > this.processingTime) {
            this.processingProgress = 0;
            this.processingTime = 0;
        }
    }

    @Override
    public void tickServer(ServerLevel serverLevel) {
        if (this.itemSyncNeeded) {
            this.syncItemToClients();
            this.itemSyncNeeded = false;
        }
        if (this.fluidSyncNeeded) {
            this.syncFluidTank(false);
            this.fluidSyncNeeded = false;
        }
        if (!this.overflow.isEmpty()) {
            this.dropItemOrPushToInventory(this.overflow);
        } else if (this.processingTime > 0) {
            ++this.processingProgress;
            this.setChanged();
            if (this.processingProgress > this.processingTime) {
                this.processingProgress = 0;
                this.processingTime = 0;
                ItemStack inputStack = this.inputInventory.extractItem(0, 1, false);
                this.getRecipeFor(inputStack).ifPresent(recipe -> {
                    ((SluiceRecipe)recipe.value()).getFluid().ifPresent(fluid -> this.fluidTank.drain((int)((double)fluid.amount() * (Double)this.getProps().fluidMod().get()), IFluidHandler.FluidAction.EXECUTE));
                    this.energyStorage.extractEnergy((Integer)this.getProps().energyCost().get(), false);
                    for (ItemWithChance result : ((SluiceRecipe)recipe.value()).getResults()) {
                        if (!((double)serverLevel.random.nextFloat() <= result.chance())) continue;
                        this.dropItemOrPushToInventory(result.item());
                    }
                });
            }
        } else {
            ItemStack inputStack = this.inputInventory.getStackInSlot(0);
            if (!inputStack.isEmpty()) {
                this.setChanged();
                this.getRecipeFor(inputStack).ifPresentOrElse(recipe -> {
                    if (this.hasEnoughEnergy() && ((SluiceRecipe)recipe.value()).testFluid(this.fluidTank.getFluid(), true, (Double)this.getProps().fluidMod().get())) {
                        double time = 60.0 * (Double)this.getProps().timeMod().get() * (double)((SluiceRecipe)recipe.value()).getProcessingTimeMultiplier();
                        this.processingTime = Math.max(1, (int)time);
                        this.processingProgress = 0;
                        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.getLevel()), (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new SendSluiceStartPacket(this.getBlockPos(), this.processingTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }, () -> {
                    this.dropItemOrPushToInventory(inputStack);
                    this.inputInventory.setStackInSlot(0, ItemStack.EMPTY);
                });
            }
        }
    }

    private boolean hasEnoughEnergy() {
        return this.energyStorage.getEnergyStored() >= (Integer)this.getProps().energyCost().get();
    }

    private void setOverflowItem(ItemStack stack) {
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.overflow, (ItemStack)stack)) {
            this.setChanged();
        }
        this.overflow = stack;
    }

    private void dropItemOrPushToInventory(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        stack = stack.copy();
        assert (this.level instanceof ServerLevel);
        IItemHandler inventory = this.getOutputInventory();
        if (inventory != null && !(stack = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false)).isEmpty()) {
            this.setOverflowItem(stack);
            return;
        }
        if (!stack.isEmpty()) {
            BlockPos pos = this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), 2);
            double my = 0.14 * ((double)this.level.random.nextFloat() * 0.4);
            ItemEntity itemEntity = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            itemEntity.setDeltaMovement(0.0, my, 0.0);
            this.level.addFreshEntity((Entity)itemEntity);
        }
        this.setOverflowItem(ItemStack.EMPTY);
    }

    public int getProgress() {
        return this.processingProgress;
    }

    @Override
    public void dropItemContents() {
        super.dropItemContents();
        if (!this.overflow.isEmpty()) {
            Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)this.overflow);
        }
    }

    @Nullable
    private IItemHandler getOutputInventory() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.outputCache == null) {
            Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            this.outputCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos().relative(facing, 2), (Object)facing.getOpposite());
        }
        return (IItemHandler)this.outputCache.getCapability();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("processingProgress", this.processingProgress);
        tag.putInt("processingTime", this.processingTime);
        this.fluidTank.writeToNBT(registries, tag);
        tag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(registries));
        if (this.energyStorage.getEnergyStored() > 0) {
            tag.put("energy", this.energyStorage.serializeNBT(registries));
        }
        if (!this.overflow.isEmpty()) {
            tag.put("overflow", this.overflow.save(registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.processingProgress = tag.getInt("processingProgress");
        this.processingTime = tag.getInt("processingTime");
        this.fluidTank.readFromNBT(registries, tag);
        this.inputInventory.deserializeNBT(registries, tag.getCompound("inputInventory"));
        Tag tag2 = tag.get("energy");
        if (tag2 instanceof IntTag) {
            IntTag intTag = (IntTag)tag2;
            this.energyStorage.deserializeNBT(registries, (Tag)intTag);
        }
        this.overflow = tag.contains("overflow") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.get("overflow")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public SluiceProperties getProps() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof SluiceBlock) {
            SluiceBlock sb = (SluiceBlock)block;
            return sb.getProps();
        }
        throw new IllegalStateException("expected a sluice block at " + String.valueOf(this.getBlockPos()) + " !");
    }

    public ItemStackHandler getItemHandler(@Nullable Direction dir) {
        return dir == null || (Boolean)this.getProps().itemIO().get() != false ? this.inputInventory : null;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return dir == null || (Boolean)this.getProps().fluidIO().get() != false || this.level.getBlockState(this.getBlockPos().relative(dir)).getBlock() instanceof PumpBlock ? this.fluidTank : null;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction dir) {
        return dir == null || (Integer)this.getProps().energyCost().get() > 0 ? this.energyStorage : null;
    }

    public ItemStack getDisplayedItem() {
        return this.inputInventory.getStackInSlot(0);
    }

    public Optional<RecipeHolder<SluiceRecipe>> getRecipeFor(ItemStack input) {
        return RecipeCaches.SLUICE.getCachedRecipe(() -> this.searchForRecipe(input), () -> this.genRecipeHash(input));
    }

    private int genRecipeHash(ItemStack input) {
        int fluidHash = FluidStack.hashFluidAndComponents((FluidStack)this.fluidTank.getFluid());
        int itemHash = ItemStack.hashItemAndComponents((ItemStack)input);
        return Objects.hash(new Object[]{fluidHash, itemHash, this.getInstalledMesh()});
    }

    private Optional<RecipeHolder<SluiceRecipe>> searchForRecipe(ItemStack input) {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipesFor(RecipesRegistry.SLUICE_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, this.level).stream().filter(r -> this.fluidItemAndMeshMatch((SluiceRecipe)r.value(), input)).findFirst();
    }

    private boolean fluidItemAndMeshMatch(SluiceRecipe recipe, ItemStack input) {
        return recipe.getIngredient().test(input) && recipe.testFluid(this.fluidTank.getFluid(), false) && recipe.getMeshTypes().contains((Object)this.getInstalledMesh());
    }

    @NotNull
    private MeshType getInstalledMesh() {
        return (MeshType)((Object)this.getBlockState().getValue(SluiceBlock.MESH));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getProcessingProgress() {
        return this.processingProgress;
    }

    public void syncItemToClients() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)SyncDisplayItemPacket.forSluice(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void syncItemFromServer(ItemStack stack) {
        this.inputInventory.setStackInSlot(0, stack);
    }

    @Override
    public void syncFluidFromServer(FluidStack fluidStack) {
        this.fluidTank.setFluid(fluidStack);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void syncProcessingTimeFromServer(int processingTime) {
        this.processingProgress = 0;
        this.processingTime = processingTime;
    }

    private class SluiceItemHandler
    extends ItemStackHandler {
        public SluiceItemHandler() {
            super(1);
        }

        protected void onContentsChanged(int slot) {
            SluiceBlockEntity.this.itemSyncNeeded = true;
            SluiceBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return SluiceBlockEntity.this.getRecipeFor(stack).isPresent();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    public static class SluiceFluidTank
    extends EmittingFluidTank {
        private final SluiceBlockEntity owner;

        public SluiceFluidTank(SluiceBlockEntity owner, int capacity, Consumer<EmittingFluidTank> onChange) {
            super(capacity, onChange);
            this.owner = owner;
        }

        public SluiceBlockEntity getOwner() {
            return this.owner;
        }
    }

    public static class Netherite
    extends SluiceBlockEntity {
        public Netherite(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.NETHERITE_SLUICE.get(), pos, blockState);
        }
    }

    public static class Diamond
    extends SluiceBlockEntity {
        public Diamond(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.DIAMOND_SLUICE.get(), pos, blockState);
        }
    }

    public static class Iron
    extends SluiceBlockEntity {
        public Iron(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.IRON_SLUICE.get(), pos, blockState);
        }
    }

    public static class Bamboo
    extends SluiceBlockEntity {
        public Bamboo(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.BAMBOO_SLUICE.get(), pos, blockState);
        }
    }

    public static class Warped
    extends SluiceBlockEntity {
        public Warped(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.WARPED_SLUICE.get(), pos, blockState);
        }
    }

    public static class Crimson
    extends SluiceBlockEntity {
        public Crimson(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.CRIMSON_SLUICE.get(), pos, blockState);
        }
    }

    public static class PaleOak
    extends SluiceBlockEntity {
        public PaleOak(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.PALE_OAK_SLUICE.get(), pos, blockState);
        }
    }

    public static class Cherry
    extends SluiceBlockEntity {
        public Cherry(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.CHERRY_SLUICE.get(), pos, blockState);
        }
    }

    public static class Mangrove
    extends SluiceBlockEntity {
        public Mangrove(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.MANGROVE_SLUICE.get(), pos, blockState);
        }
    }

    public static class DarkOak
    extends SluiceBlockEntity {
        public DarkOak(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.DARK_OAK_SLUICE.get(), pos, blockState);
        }
    }

    public static class Acacia
    extends SluiceBlockEntity {
        public Acacia(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.ACACIA_SLUICE.get(), pos, blockState);
        }
    }

    public static class Jungle
    extends SluiceBlockEntity {
        public Jungle(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.JUNGLE_SLUICE.get(), pos, blockState);
        }
    }

    public static class Birch
    extends SluiceBlockEntity {
        public Birch(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.BIRCH_SLUICE.get(), pos, blockState);
        }
    }

    public static class Spruce
    extends SluiceBlockEntity {
        public Spruce(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.SPRUCE_SLUICE.get(), pos, blockState);
        }
    }

    public static class Oak
    extends SluiceBlockEntity {
        public Oak(BlockPos pos, BlockState blockState) {
            super((BlockEntityType)BlockEntitiesRegistry.OAK_SLUICE.get(), pos, blockState);
        }
    }
}

