/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.strainer;

import dev.ftb.mods.ftbstuffnthings.Config;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerMenu;
import dev.ftb.mods.ftbstuffnthings.capabilities.ComparatorItemStackHandler;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class WaterStrainerBlockEntity
extends AbstractMachineBlockEntity {
    private final ComparatorItemStackHandler inventory = new ComparatorItemStackHandler(27){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WaterStrainerBlockEntity.this.setChanged();
        }
    };
    private final IItemHandler extractOnly = new ExtractOnlyHandlerWrapper((IItemHandler)this.inventory);
    private static LootTable lootTable = null;

    public WaterStrainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.WATER_STRAINER.get(), pos, state);
    }

    @Override
    public void tickServer(ServerLevel serverLevel) {
        LootTable table;
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && serverLevel.getGameTime() % (long)((Integer)Config.STRAINER_TICK_RATE.get()).intValue() == 0L && (table = this.getLootTable(serverLevel)) != null) {
            LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withParameter(LootContextParams.BLOCK_STATE, (Object)this.getBlockState()).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this).create(LootContextParamSets.CHEST);
            table.getRandomItems(params, stack -> {
                if (!stack.isEmpty()) {
                    ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                }
            });
        }
    }

    private LootTable getLootTable(ServerLevel serverLevel) {
        if (lootTable == null) {
            try {
                ResourceLocation tableId = Config.getStrainerLootTable().orElseThrow(() -> new IllegalStateException("invalid strainer loot table resource location"));
                lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)tableId));
            }
            catch (IllegalStateException e) {
                FTBStuffNThings.LOGGER.error("can't retrieve water strainer loot table (using empty loot table): {}", (Object)e.getMessage());
                lootTable = LootTable.EMPTY;
            }
        }
        return lootTable;
    }

    @Override
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new WaterStrainerMenu(containerId, playerInventory, this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction side) {
        return side == null ? this.inventory : this.extractOnly;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        return null;
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(@Nullable Direction side) {
        return null;
    }

    public static void clearCachedLootTable() {
        lootTable = null;
    }

    public int getComparatorLevel() {
        return this.inventory.getComparatorLevel();
    }

    public record ExtractOnlyHandlerWrapper(IItemHandler wrapped) implements IItemHandler
    {
        public int getSlots() {
            return this.wrapped.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

