/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.tube;

import dev.ftb.mods.ftbstuffnthings.blocks.tube.ITubeConnectable;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.util.DirectionUtil;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class TubeBlockEntity
extends BlockEntity
implements ITubeConnectable {
    public static final ModelProperty<Integer> CONNECTION_PROPERTY = new ModelProperty();
    private int sidesClosed = 0;
    private int sidesConnected = 0;

    public TubeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntitiesRegistry.TUBE.get(), blockPos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.sidesClosed = tag.getInt("sides_closed");
        this.sidesConnected = tag.getInt("sides_connected");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.sidesClosed != 0) {
            tag.putInt("sides_closed", this.sidesClosed);
        }
        if (this.sidesConnected != 0) {
            tag.putInt("sides_connected", this.sidesConnected);
        }
    }

    public int getShapeCacheKey() {
        return Objects.hash(this.sidesClosed, this.sidesConnected);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.saveAdditional((CompoundTag)tag, registries));
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.requestModelDataUpdate();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.requestModelDataUpdate();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(CONNECTION_PROPERTY, (Object)this.sidesConnected).build();
    }

    public boolean isSideClosed(Direction dir) {
        return DirectionUtil.getDirectionBit(this.sidesClosed, dir);
    }

    public void setSideClosed(Direction dir, boolean closed) {
        if (!this.level.isClientSide) {
            int prevSidesClosed = this.sidesClosed;
            this.sidesClosed = DirectionUtil.setDirectionBit(this.sidesClosed, dir, closed);
            if (this.sidesClosed != prevSidesClosed) {
                this.setChanged();
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public boolean isSideConnected(Direction dir) {
        return DirectionUtil.getDirectionBit(this.sidesConnected, dir);
    }

    public boolean updateSide(Direction dir, boolean updateNow) {
        int prevSidesConnected = this.sidesConnected;
        BlockPos pos1 = this.getBlockPos().relative(dir);
        Direction dir1 = dir.getOpposite();
        boolean connectable = !this.isSideClosed(dir) && ITubeConnectable.canConnect(this.level, pos1, dir1);
        this.sidesConnected = DirectionUtil.setDirectionBit(this.sidesConnected, dir, connectable);
        if (this.sidesConnected != prevSidesConnected) {
            if (updateNow) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.setChanged();
            return true;
        }
        return false;
    }

    public void updateConnectedSides() {
        boolean changed = false;
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.updateSide(dir, false)) continue;
            changed = true;
        }
        if (changed) {
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    public boolean isSideTubeConnectable(Direction side) {
        return !this.isSideClosed(side);
    }
}

