/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.woodbasin;

import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.WoodenBasinRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class WoodenBasinBlockEntity
extends BlockEntity {
    private final FluidTank tank;
    private FluidStack prevFluid = FluidStack.EMPTY;

    public WoodenBasinBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntitiesRegistry.WOODEN_BASIN.get(), blockPos, blockState);
        this.tank = new FluidTank(4000){

            protected void onContentsChanged() {
                WoodenBasinBlockEntity.this.fluidChanged();
            }
        };
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tank.readFromNBT(provider, tag.getCompound("Tank"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.saveAdditional((CompoundTag)tag, provider));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void trySqueezing(Entity fallingEntity) {
        RecipeCaches.WOODEN_BASIN.getCachedRecipe(this::searchForRecipe, this::genRecipeHash).ifPresent(h -> {
            WoodenBasinRecipe recipe = (WoodenBasinRecipe)h.value();
            if (recipe.getProductionChance() >= 1.0f || this.level.getRandom().nextFloat() < recipe.getProductionChance()) {
                int filled = this.tank.fill(recipe.getFluid(), IFluidHandler.FluidAction.SIMULATE);
                if (filled == recipe.getFluid().getAmount()) {
                    this.tank.fill(recipe.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    if (recipe.getBlockConsumeChance() >= 1.0f || this.level.getRandom().nextFloat() < recipe.getBlockConsumeChance()) {
                        this.level.destroyBlock(this.getBlockPos().above(), recipe.dropItems(), fallingEntity);
                    } else {
                        this.level.playSound(null, this.getBlockPos().above(), SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.sendParticles(fallingEntity, recipe.getFluid().getFluid());
                    }
                } else if (fallingEntity instanceof Player) {
                    Player p = (Player)fallingEntity;
                    p.displayClientMessage((Component)Component.translatable((String)"ftbstuff.wooden_basin.full_tank").withStyle(ChatFormatting.GOLD), true);
                }
            }
        });
    }

    private void sendParticles(Entity entity, Fluid fluid) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.getBlockPos()), false).forEach(player -> {
                SimpleParticleType particle;
                Object object = particle = fluid.getFluidType().getDripInfo() != null ? fluid.getFluidType().getDripInfo().dripParticle() : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
                if (particle == null) {
                    particle = ParticleTypes.DRIPPING_DRIPSTONE_WATER;
                }
                Vec3 pos = Vec3.atCenterOf((Vec3i)this.getBlockPos()).add(0.0, 1.8, 0.0);
                player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)particle, true, pos.x, pos.y - 0.5, pos.z, 0.3f, 0.1f, 0.3f, 0.05f, 20));
            });
        }
    }

    private int genRecipeHash() {
        BlockState blockAbove = this.getLevel().getBlockState(this.getBlockPos().above());
        return Objects.hash(blockAbove);
    }

    private Optional<RecipeHolder<WoodenBasinRecipe>> searchForRecipe() {
        return this.getLevel().getRecipeManager().getRecipesFor(RecipesRegistry.WOODEN_BASIN_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, this.getLevel()).stream().filter(r -> ((WoodenBasinRecipe)r.value()).testInput(new BlockInWorld((LevelReader)this.level, this.getBlockPos().above(), true))).findFirst();
    }

    private void fluidChanged() {
        this.setChanged();
        if (!this.level.isClientSide() && this.fluidsDifferentEnough(this.prevFluid)) {
            this.prevFluid = this.tank.getFluid().copy();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
        }
    }

    private boolean fluidsDifferentEnough(FluidStack prev) {
        int a2;
        if (prev.getFluid() != this.tank.getFluid().getFluid()) {
            return true;
        }
        int a1 = prev.getAmount() / (this.tank.getCapacity() / 10);
        return a1 != (a2 = this.tank.getFluid().getAmount() / (this.tank.getCapacity() / 10));
    }

    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public FluidTank getTank() {
        return this.tank;
    }
}

