/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.capabilities;

import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineMenu;
import dev.ftb.mods.ftbstuffnthings.network.SyncDisplayFluidPacket;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

public class EmittingFluidTank
extends FluidTank {
    private final Consumer<EmittingFluidTank> onChange;
    private boolean syncAllObservers;
    private final Set<ServerPlayer> toSync = Collections.newSetFromMap(new WeakHashMap());

    public EmittingFluidTank(int capacity, Consumer<EmittingFluidTank> onChange) {
        super(capacity);
        this.onChange = onChange;
    }

    public EmittingFluidTank(int capacity, Predicate<FluidStack> validator, Consumer<EmittingFluidTank> onChange) {
        super(capacity, validator);
        this.onChange = onChange;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        this.onChange.accept(this);
        this.needSync(new ServerPlayer[0]);
    }

    public void needSync(ServerPlayer ... players) {
        if (players.length == 0) {
            this.syncAllObservers = true;
        } else {
            this.toSync.addAll(Arrays.asList(players));
        }
    }

    public void syncToContainers(BlockEntity blockEntity) {
        if (this.syncAllObservers) {
            blockEntity.getLevel().getServer().getPlayerList().getPlayers().stream().filter(p -> {
                AbstractMachineMenu prov;
                AbstractContainerMenu patt0$temp = p.containerMenu;
                return patt0$temp instanceof AbstractMachineMenu && (prov = (AbstractMachineMenu)patt0$temp).getBlockEntity() == blockEntity;
            }).forEach(this.toSync::add);
        }
        if (!this.toSync.isEmpty()) {
            SyncDisplayFluidPacket syncDisplayFluidPacket = new SyncDisplayFluidPacket(blockEntity.getBlockPos(), this.fluid);
            this.toSync.forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)syncDisplayFluidPacket, (CustomPacketPayload[])new CustomPacketPayload[0]));
            this.toSync.clear();
        }
        this.syncAllObservers = false;
    }

    public void syncToTrackers(AbstractMachineBlockEntity machine) {
        Level level = machine.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            SyncDisplayFluidPacket packet = new SyncDisplayFluidPacket(machine.getBlockPos(), this.fluid);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(machine.getBlockPos()), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

