/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.capabilities;

import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingStackHandler;
import java.util.function.BiConsumer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class IOStackHandler
implements IItemHandler {
    private final ItemStackHandler input;
    private final ItemStackHandler output;

    public IOStackHandler(int inputSlots, int outputSlots, BiConsumer<IOStackHandler, IO> onChange) {
        this.input = new EmittingStackHandler(inputSlots, contents -> onChange.accept(this, IO.INPUT));
        this.output = new EmittingStackHandler(outputSlots, contents -> onChange.accept(this, IO.OUTPUT));
    }

    public int getSlots() {
        return this.input.getSlots() + this.output.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return i < this.input.getSlots() ? this.input.getStackInSlot(i) : this.output.getStackInSlot(i - this.input.getSlots());
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean bl) {
        return i < this.input.getSlots() ? this.input.insertItem(i, arg, bl) : arg;
    }

    @NotNull
    public ItemStack extractItem(int i, int j, boolean bl) {
        return i < this.input.getSlots() ? ItemStack.EMPTY : this.output.extractItem(i - this.input.getSlots(), j, bl);
    }

    public int getSlotLimit(int i) {
        return i < this.input.getSlots() ? this.input.getSlotLimit(i) : this.output.getSlotLimit(i - this.input.getSlots());
    }

    public boolean isItemValid(int i, @NotNull ItemStack arg) {
        return i < this.input.getSlots() && this.input.isItemValid(i, arg);
    }

    public ItemStackHandler getInput() {
        return this.input;
    }

    public ItemStackHandler getOutput() {
        return this.output;
    }

    public static enum IO {
        INPUT,
        OUTPUT;

    }
}

