/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class SluiceBlockEntityRenderer
implements BlockEntityRenderer<SluiceBlockEntity> {
    public SluiceBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SluiceBlockEntity sluice, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int otherlight) {
        FluidStack fluid = sluice.getFluidTank().getFluid();
        if (!fluid.isEmpty()) {
            this.renderFluid(sluice, fluid, matrix, renderer, light, otherlight);
        }
        if (sluice.getProcessingTime() == 0) {
            return;
        }
        ItemStack resource = sluice.getDisplayedItem();
        if (resource.isEmpty()) {
            return;
        }
        int progress = sluice.getProcessingProgress() * 100 / Math.max(1, sluice.getProcessingTime());
        float offset = sluice.getProcessingProgress() < 0 ? 0.0f : (float)progress;
        float v = ((Direction)sluice.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot();
        matrix.pushPose();
        matrix.translate(0.5f, 0.85f - offset / 250.0f, 0.5f);
        matrix.scale(1.4f, 1.4f, 1.4f);
        matrix.mulPose(Axis.YN.rotationDegrees(45.0f + v));
        Minecraft.getInstance().getItemRenderer().renderStatic(resource, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, light, otherlight, matrix, renderer, (Level)Minecraft.getInstance().level, 0);
        matrix.popPose();
    }

    private void renderFluid(SluiceBlockEntity te, FluidStack fluid, PoseStack matrix, MultiBufferSource renderer, int light, int otherlight) {
        VertexConsumer builder = renderer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation texture = renderProps.getFlowingTexture(fluid);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        int[] cols = SluiceBlockEntityRenderer.decomposeColor(renderProps.getTintColor(fluid));
        float r = (float)cols[1] / 255.0f;
        float g = (float)cols[2] / 255.0f;
        float b = (float)cols[3] / 255.0f;
        float a = (float)cols[0] / 255.0f;
        float y1 = 0.5f;
        float u0top = sprite.getU(0.1875f);
        float v0top = sprite.getV(0.1875f);
        float u1top = sprite.getU(0.8125f);
        float v1top = sprite.getV(0.8125f);
        Direction facing = (Direction)te.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrix.pushPose();
        matrix.translate(0.5, 0.0, 0.5);
        matrix.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        PoseStack.Pose last = matrix.last();
        Matrix4f matrix4 = last.pose();
        builder.addVertex(matrix4, -0.38f, y1, -0.39f).setColor(r, g, b, a).setUv(u0top, v0top).setOverlay(otherlight).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, -0.38f, 0.13f, 0.45f).setColor(r, g, b, a).setUv(u0top, v1top).setOverlay(otherlight).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, 0.38f, 0.13f, 0.45f).setColor(r, g, b, a).setUv(u1top, v1top).setOverlay(otherlight).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, 0.38f, y1, -0.39f).setColor(r, g, b, a).setUv(u1top, v0top).setOverlay(otherlight).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        matrix.popPose();
        matrix.pushPose();
        matrix.translate(0.0f, -0.87f, 0.0f);
        matrix.translate(facing.getAxisDirection() == Direction.AxisDirection.POSITIVE && facing.getAxis() == Direction.Axis.X || facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE && facing.getAxis() == Direction.Axis.Z ? 1.0f : 0.0f, 0.0f, facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0f : 0.0f);
        if (facing.getAxis() == Direction.Axis.Z) {
            matrix.mulPose(Axis.YP.rotationDegrees(facing.getAxisDirection() != Direction.AxisDirection.POSITIVE ? 180.0f : 0.0f));
        } else {
            matrix.mulPose(Axis.YP.rotationDegrees(facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 90.0f : -90.0f));
        }
        last = matrix.last();
        matrix4 = last.pose();
        builder.addVertex(matrix4, 0.1f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(u0top, v0top).setOverlay(otherlight).setLight(light).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, 0.1f, 1.0f, 1.0f).setColor(r, g, b, a).setUv(u0top, v1top).setOverlay(otherlight).setLight(light).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, 0.9f, 1.0f, 1.0f).setColor(r, g, b, a).setUv(u1top, v1top).setOverlay(otherlight).setLight(light).setNormal(last, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4, 0.9f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(u1top, v0top).setOverlay(otherlight).setLight(light).setNormal(last, 0.0f, 1.0f, 0.0f);
        matrix.popPose();
    }

    public static int[] decomposeColor(int color) {
        int[] res = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public AABB getRenderBoundingBox(SluiceBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(1.0);
    }
}

