/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client.screens;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarMenu;
import dev.ftb.mods.ftbstuffnthings.client.GuiUtil;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import dev.ftb.mods.ftbstuffnthings.network.ToggleJarCraftingPacket;
import dev.ftb.mods.ftbstuffnthings.temperature.TemperatureAndEfficiency;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TemperedJarScreen
extends AbstractContainerScreen<TemperedJarMenu> {
    private static final ResourceLocation TEXTURE = FTBStuffNThings.id("textures/gui/tempered_jar.png");
    private static final ResourceLocation CRAFTING_ICON = FTBStuffNThings.id("textures/gui/crafting_icon.png");
    public static final Rect2i FLUID_AREA = new Rect2i(55, 30, 48, 76);
    public static final Rect2i TEMPERATURE_AREA = new Rect2i(55 + FLUID_AREA.getWidth() / 2 - 8, 30 + FLUID_AREA.getHeight() + 5, 16, 16);
    public static final Rect2i JEI_AREA = new Rect2i(132, 75, 16, 16);
    private Button startButton;

    public TemperedJarScreen(TemperedJarMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 214;
        this.inventoryLabelY = 125;
    }

    protected void init() {
        super.init();
        this.startButton = Button.builder((Component)Component.translatable((String)"ftbstuff.start_mix"), b -> ToggleJarCraftingPacket.sendToServer()).size(56, 20).pos(this.leftPos + 112, this.topPos + 40).build();
        this.addRenderableWidget((GuiEventListener)this.startButton);
    }

    protected void containerTick() {
        super.containerTick();
        TemperedJarBlockEntity.JarStatus status = ((TemperedJarMenu)this.menu).getJar().getStatus();
        this.startButton.active = status == TemperedJarBlockEntity.JarStatus.READY || status == TemperedJarBlockEntity.JarStatus.CRAFTING;
        this.startButton.setMessage((Component)Component.translatable((String)(((TemperedJarMenu)this.menu).getJar().getRemainingTime() > 0 ? "ftbstuff.stop_mix" : "ftbstuff.start_mix")));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int minX = this.leftPos + FLUID_AREA.getX();
        int maxX = this.leftPos + FLUID_AREA.getX() + FLUID_AREA.getWidth();
        int minY = this.topPos + FLUID_AREA.getY();
        int maxY = this.topPos + FLUID_AREA.getY() + FLUID_AREA.getHeight();
        guiGraphics.fill(minX, minY, maxX, maxY, -7631989);
        guiGraphics.blit(TEXTURE, minX - 4, minY - 13, 176, 0, 56, 94);
        guiGraphics.blit(CRAFTING_ICON, this.leftPos + JEI_AREA.getX(), this.topPos + JEI_AREA.getY(), 0.0f, 0.0f, 16, 16, 16, 16);
        this.renderTemperatureIndicator(guiGraphics, mouseX, mouseY, minX, maxY);
        this.renderFluids(guiGraphics, mouseX, mouseY);
        this.renderProgressBar(guiGraphics);
        this.renderStatusInfo(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderTemperatureIndicator(GuiGraphics guiGraphics, int mouseX, int mouseY, int xPos, int yPos) {
        TemperatureAndEfficiency temp = ((TemperedJarMenu)this.menu).getJar().getTemperature();
        guiGraphics.blit(temp.temperature().getTexture(), this.leftPos + TEMPERATURE_AREA.getX(), this.topPos + TEMPERATURE_AREA.getY(), 0.0f, 0.0f, 16, 16, 16, 16);
        if (!ModList.get().isLoaded("jei") && TEMPERATURE_AREA.contains(mouseX - this.leftPos, mouseY - this.topPos)) {
            List<MutableComponent> list = List.of(Component.translatable((String)"ftbstuff.temperature", (Object[])new Object[]{temp.temperature().getName()}), Component.translatable((String)"ftbstuff.efficiency", (Object[])new Object[]{temp.formatEfficiency()}));
            guiGraphics.renderTooltip(this.font, list, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderStatusInfo(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.startButton.isHovered()) {
            ArrayList<Component> outputs = new ArrayList<Component>();
            outputs.add(((TemperedJarMenu)this.getMenu()).getJar().getStatus().displayString());
            ((TemperedJarMenu)this.getMenu()).getJar().getCurrentRecipe().ifPresent(holder -> {
                outputs.add((Component)Component.translatable((String)"ftbstuff.making"));
                ((JarRecipe)holder.value()).getOutputItems().forEach(stack -> outputs.add((Component)Component.literal((String)"\u2022 ").append(stack.getCount() + " x ").append(stack.getHoverName())));
                ((JarRecipe)holder.value()).getOutputFluids().forEach(stack -> outputs.add((Component)Component.literal((String)"\u2022 ").append(stack.getAmount() + "mB ").append(stack.getHoverName())));
                if (Minecraft.getInstance().options.advancedItemTooltips) {
                    outputs.add((Component)Component.literal((String)("Recipe: " + String.valueOf(holder.id()))).withStyle(ChatFormatting.DARK_GRAY));
                }
            });
            guiGraphics.renderTooltip(this.font, outputs, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderProgressBar(GuiGraphics guiGraphics) {
        int remaining = ((TemperedJarMenu)this.menu).getJar().getRemainingTime();
        int total = ((TemperedJarMenu)this.menu).getJar().getProcessingTime();
        if (((TemperedJarMenu)this.menu).getJar().getStatus() == TemperedJarBlockEntity.JarStatus.CRAFTING && total > 0) {
            int x1 = this.startButton.getX();
            int x2 = this.startButton.getX() + this.startButton.getWidth();
            int y1 = this.startButton.getY() + this.startButton.getHeight() + 2;
            int y2 = y1 + 8;
            guiGraphics.fill(x1 - 1, y1 - 1, x2 + 1, y2 + 1, -10461088);
            guiGraphics.fill(x1, y1, x2, y2, -6250336);
            guiGraphics.blit(TEXTURE, x1, y1, 0, 240, (x2 - x1) * (total - remaining) / total, 8);
        }
    }

    private void renderFluids(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IFluidHandler fluidHandler = ((TemperedJarMenu)this.menu).getJar().getFluidHandler();
        int yPos = FLUID_AREA.getY() + FLUID_AREA.getHeight();
        int total = fluidHandler.getTanks() * 8000;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack fs = fluidHandler.getFluidInTank(i);
            if (fs.isEmpty()) continue;
            int ySize = FLUID_AREA.getHeight() * fs.getAmount() / total;
            GuiUtil.drawFluid(guiGraphics, new Rect2i(FLUID_AREA.getX(), yPos -= ySize, FLUID_AREA.getWidth(), ySize), fs, null);
        }
        guiGraphics.pose().popPose();
        if (FLUID_AREA.contains(mouseX - this.leftPos, mouseY - this.topPos)) {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            for (int i = fluidHandler.getTanks() - 1; i >= 0; --i) {
                FluidStack fs = fluidHandler.getFluidInTank(i);
                if (fs.isEmpty()) continue;
                lines.add(Component.translatable((String)"ftblibrary.mb", (Object[])new Object[]{fs.getAmount(), fs.getHoverName()}));
            }
            guiGraphics.renderTooltip(this.font, lines, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        guiGraphics.drawString(this.font, this.title, x, this.titleLabelY, -12566464, false);
    }
}

