/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.EnergyRequirement;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class SuperCoolerRecipe
extends BaseRecipe<SuperCoolerRecipe> {
    private final List<Ingredient> inputs;
    private final EnergyRequirement energyRequirement;
    private final SizedFluidIngredient fluidInput;
    private final ItemStack result;

    public SuperCoolerRecipe(List<Ingredient> inputs, SizedFluidIngredient fluidInput, EnergyRequirement energyRequirement, ItemStack result) {
        super(RecipesRegistry.SUPER_COOLER_SERIALIZER, RecipesRegistry.SUPER_COOLER_TYPE);
        this.inputs = inputs;
        this.fluidInput = fluidInput;
        this.energyRequirement = energyRequirement;
        this.result = result;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public SizedFluidIngredient getFluidInput() {
        return this.fluidInput;
    }

    public EnergyRequirement getEnergyComponent() {
        return this.energyRequirement;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean test(IItemHandler itemHandler, FluidStack fluidStack) {
        if (!this.getFluidInput().ingredient().test(fluidStack)) {
            return false;
        }
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.getInputs());
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(itemHandler.getStackInSlot(i))) continue;
                iter.remove();
                ++found;
                break;
            }
            if (found != this.getInputs().size()) continue;
            return true;
        }
        return false;
    }

    public static class Serializer<T extends SuperCoolerRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("inputs").forGetter(SuperCoolerRecipe::getInputs), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(SuperCoolerRecipe::getFluidInput), (App)EnergyRequirement.CODEC.fieldOf("energy").forGetter(SuperCoolerRecipe::getEnergyComponent), (App)ItemStack.CODEC.fieldOf("result").forGetter(SuperCoolerRecipe::getResult)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), SuperCoolerRecipe::getInputs, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, SuperCoolerRecipe::getFluidInput, EnergyRequirement.STREAM_CODEC, SuperCoolerRecipe::getEnergyComponent, (StreamCodec)ItemStack.STREAM_CODEC, SuperCoolerRecipe::getResult, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends SuperCoolerRecipe> {
        public T create(List<Ingredient> var1, SizedFluidIngredient var2, EnergyRequirement var3, ItemStack var4);
    }
}

