/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.blocks.SerializableComponentsProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.BarrelBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.CrateBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.SmallCrateBlock;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class LootTablesGenerator
extends LootTableProvider {
    public LootTablesGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK)), registries);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    private static class BlockLoot
    extends BlockLootSubProvider {
        private BlockLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.DEFAULT_FLAGS, provider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return BlocksRegistry.BLOCKS.getEntries().stream().filter(holder -> BuiltInRegistries.ITEM.containsKey(holder.getId())).map(DeferredHolder::get).collect(Collectors.toList());
        }

        protected void generate() {
            for (DeferredHolder holder : BlocksRegistry.BLOCKS.getEntries()) {
                Block b = (Block)holder.get();
                if (b instanceof EntityBlock && BuiltInRegistries.ITEM.containsKey(holder.getId())) {
                    this.addStandardSerializedDrop(b, holder.getId());
                    continue;
                }
                if (b.asItem() == Items.AIR || b instanceof CrateBlock || b instanceof SmallCrateBlock || b instanceof BarrelBlock) continue;
                this.dropSelf(b);
            }
            BlocksRegistry.BARRELS.forEach(barrel -> {
                String name = barrel.getId().getPath();
                this.add((Block)barrel.get(), LootTable.lootTable().withPool(LootPool.lootPool().name(name)));
            });
            this.add((Block)BlocksRegistry.CRATE.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("crate")));
            this.add((Block)BlocksRegistry.SMALL_CRATE.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("small_crate")));
            this.add((Block)BlocksRegistry.PULSATING_CRATE.get(), LootTable.lootTable().withPool(LootPool.lootPool().name("pulsating_crate")));
        }

        private void addStandardSerializedDrop(Block block, ResourceLocation blockId) {
            LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
            if (block instanceof SerializableComponentsProvider) {
                SerializableComponentsProvider scp = (SerializableComponentsProvider)block;
                ArrayList components = new ArrayList();
                scp.addSerializableComponents(components);
                if (!components.isEmpty()) {
                    CopyComponentsFunction.Builder compBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
                    components.forEach(arg_0 -> ((CopyComponentsFunction.Builder)compBuilder).include(arg_0));
                    lootBuilder.apply((LootItemFunction.Builder)compBuilder);
                }
            }
            LootPool.Builder builder = LootPool.lootPool().name(blockId.getPath()).when(ExplosionCondition.survivesExplosion()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)lootBuilder);
            this.add(block, LootTable.lootTable().withPool(builder));
        }
    }
}

