/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlock;
import dev.ftb.mods.ftbstuffnthings.crafting.DevEnvironmentCondition;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.data.recipe.CrookRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.DripperRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.FusingMachineRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.HammerRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.SluiceRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.SuperCoolerRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.TemperatureSourceRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.TemperedJarRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.data.recipe.WoodenBasinRecipeBuilder;
import dev.ftb.mods.ftbstuffnthings.items.HammerItem;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class RecipesGenerator
extends RecipeProvider {
    public RecipesGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        RecipesGenerator.shaped((Item)ItemsRegistry.CAST_IRON_INGOT.get(), Items.IRON_INGOT, "NNN/NNN/NNN", Character.valueOf('N'), FTBStuffTags.Items.NUGGETS_CAST_IRON).save(output, FTBStuffNThings.id("cast_iron_ingot_from_nugget"));
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.CAST_IRON_BLOCK.get(), (FeatureElement)ItemsRegistry.CAST_IRON_INGOT.get(), "III/III/III", Character.valueOf('I'), FTBStuffTags.Items.INGOTS_CAST_IRON).save(output);
        RecipesGenerator.shaped((Item)ItemsRegistry.CAST_IRON_GEAR.get(), (Item)ItemsRegistry.CAST_IRON_INGOT.get(), " I /I I/ I ", Character.valueOf('I'), FTBStuffTags.Items.INGOTS_CAST_IRON).save(output);
        RecipesGenerator.shapeless((FeatureElement)ItemsRegistry.CAST_IRON_INGOT.get(), 9, (FeatureElement)BlocksRegistry.CAST_IRON_BLOCK.get(), new Object[0]).save(output, FTBStuffNThings.id("cast_iron_ingot_from_block"));
        RecipesGenerator.shapeless((Item)ItemsRegistry.CAST_IRON_NUGGET.get(), 9, (Item)ItemsRegistry.CAST_IRON_INGOT.get(), new Object[0]).save(output);
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemsRegistry.CAST_IRON_INGOT.get()), (float)0.1f, (int)600).unlockedBy("has_ingot", RecipesGenerator.has((TagKey)Tags.Items.INGOTS_IRON)).save(output, FTBStuffNThings.id("cast_iron_ingot_from_campfire"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_PANES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemsRegistry.TEMPERED_GLASS.get()), (float)0.1f, (int)600).unlockedBy("has_glass", RecipesGenerator.has((TagKey)Tags.Items.GLASS_PANES)).save(output, FTBStuffNThings.id("tempered_glass_from_campfire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((TagKey)Tags.Items.GLASS_PANES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemsRegistry.TEMPERED_GLASS.get()), (float)0.1f, (int)200).unlockedBy("has_glass", RecipesGenerator.has((TagKey)Tags.Items.GLASS_PANES)).save(output, FTBStuffNThings.id("tempered_glass_from_furnace"));
        RecipesGenerator.shaped((ItemLike)ItemsRegistry.TEMPERED_JAR.get(), ItemsRegistry.TEMPERED_GLASS, "GIG/G G/GGG", new Object[]{Character.valueOf('I'), ItemsRegistry.CAST_IRON_INGOT, Character.valueOf('G'), ItemsRegistry.TEMPERED_GLASS}).save(output);
        RecipesGenerator.shaped((Item)ItemsRegistry.JAR.get(), Items.GLASS, "GBG/G G/GGG", Character.valueOf('B'), ItemTags.WOODEN_BUTTONS, Character.valueOf('G'), Tags.Items.GLASS_PANES).save(output);
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.JAR_AUTOMATER.get(), (FeatureElement)ItemsRegistry.TEMPERED_JAR.get(), "CDC/CPC/CHC", Character.valueOf('C'), ItemsRegistry.CAST_IRON_INGOT.get(), Character.valueOf('D'), Blocks.DROPPER, Character.valueOf('P'), Blocks.PISTON, Character.valueOf('H'), Blocks.HOPPER).save(output);
        RecipesGenerator.shaped((Block)BlocksRegistry.BLUE_MAGMA_BLOCK.get(), Blocks.MAGMA_BLOCK, "SMS/MLM/SMS", Character.valueOf('S'), Blocks.SOUL_SAND, Character.valueOf('L'), Items.LAVA_BUCKET, Character.valueOf('M'), Blocks.MAGMA_BLOCK).save(output);
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.DRIPPER.get(), Items.STICK, "SPS/SBS", new Object[]{Character.valueOf('S'), Tags.Items.RODS_WOODEN, Character.valueOf('P'), ItemTags.WOODEN_SLABS, Character.valueOf('B'), ItemTags.WOODEN_BUTTONS}).save(output);
        RecipesGenerator.shaped((Item)ItemsRegistry.STONE_ROD.get(), Items.COBBLESTONE, "S/S", Character.valueOf('S'), Items.COBBLESTONE).save(output);
        RecipesGenerator.shaped((ItemLike)ItemsRegistry.CROOK.get(), ItemsRegistry.STONE_ROD, "SS/ S/ S", new Object[]{Character.valueOf('S'), ItemsRegistry.STONE_ROD}).save(output);
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.PUMP.get(), Items.CLAY_BALL, "WWW/SSS/BBB", new Object[]{Character.valueOf('W'), Tags.Items.BUCKETS_WATER, Character.valueOf('S'), Items.STONE, Character.valueOf('B'), Items.OAK_PLANKS}).save(output);
        this.waterStrainer(BlocksRegistry.ACACIA_STRAINER, Blocks.ACACIA_PLANKS, output);
        this.waterStrainer(BlocksRegistry.BAMBOO_STRAINER, Blocks.BAMBOO_PLANKS, output);
        this.waterStrainer(BlocksRegistry.BIRCH_STRAINER, Blocks.BIRCH_PLANKS, output);
        this.waterStrainer(BlocksRegistry.CHERRY_STRAINER, Blocks.CHERRY_PLANKS, output);
        this.waterStrainer(BlocksRegistry.CRIMSON_STRAINER, Blocks.CRIMSON_PLANKS, output);
        this.waterStrainer(BlocksRegistry.DARK_OAK_STRAINER, Blocks.DARK_OAK_PLANKS, output);
        this.waterStrainer(BlocksRegistry.JUNGLE_STRAINER, Blocks.JUNGLE_PLANKS, output);
        this.waterStrainer(BlocksRegistry.MANGROVE_STRAINER, Blocks.MANGROVE_PLANKS, output);
        this.waterStrainer(BlocksRegistry.OAK_STRAINER, Blocks.OAK_PLANKS, output);
        this.waterStrainer(BlocksRegistry.SPRUCE_STRAINER, Blocks.SPRUCE_PLANKS, output);
        this.waterStrainer(BlocksRegistry.WARPED_STRAINER, Blocks.WARPED_PLANKS, output);
        for (MeshType type : MeshType.NON_EMPTY_VALUES) {
            RecipesGenerator.shaped(type.getItemStack().getItem(), Items.STRING, "SIS/ICI/SIS", Character.valueOf('S'), Tags.Items.RODS_WOODEN, Character.valueOf('I'), type.getIngredientTag(), Character.valueOf('C'), Tags.Items.STRINGS).save(output);
        }
        this.woodSluice(BlocksRegistry.OAK_SLUICE, Blocks.OAK_LOG, output);
        this.woodSluice(BlocksRegistry.SPRUCE_SLUICE, Blocks.SPRUCE_LOG, output);
        this.woodSluice(BlocksRegistry.BIRCH_SLUICE, Blocks.BIRCH_LOG, output);
        this.woodSluice(BlocksRegistry.JUNGLE_SLUICE, Blocks.JUNGLE_LOG, output);
        this.woodSluice(BlocksRegistry.ACACIA_SLUICE, Blocks.ACACIA_LOG, output);
        this.woodSluice(BlocksRegistry.DARK_OAK_SLUICE, Blocks.DARK_OAK_LOG, output);
        this.woodSluice(BlocksRegistry.MANGROVE_SLUICE, Blocks.MANGROVE_LOG, output);
        this.woodSluice(BlocksRegistry.CHERRY_SLUICE, Blocks.CHERRY_LOG, output);
        this.woodSluice(BlocksRegistry.CRIMSON_SLUICE, Blocks.CRIMSON_STEM, output);
        this.woodSluice(BlocksRegistry.WARPED_SLUICE, Blocks.WARPED_STEM, output);
        this.woodSluice(BlocksRegistry.BAMBOO_SLUICE, Blocks.BAMBOO_BLOCK, output);
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.IRON_SLUICE.get(), Items.STICK, "IC/SI", new Object[]{Character.valueOf('I'), Tags.Items.INGOTS_IRON, Character.valueOf('C'), Items.CHAIN, Character.valueOf('S'), FTBStuffTags.Items.WOODEN_SLUICES}).save(output);
        RecipesGenerator.shaped((FeatureElement)BlocksRegistry.DIAMOND_SLUICE.get(), Items.STICK, "DD/SD", new Object[]{Character.valueOf('D'), Tags.Items.GEMS_DIAMOND, Character.valueOf('S'), BlocksRegistry.IRON_SLUICE.get()}).save(output);
        RecipesGenerator.netheriteSmithing((RecipeOutput)output, (Item)BlocksRegistry.DIAMOND_SLUICE.asItem(), (RecipeCategory)RecipeCategory.TOOLS, (Item)BlocksRegistry.NETHERITE_SLUICE.asItem());
        this.shapedHammer(ItemsRegistry.STONE_HAMMER, (ItemLike)Items.COBBLESTONE, (TagKey<Item>)Tags.Items.COBBLESTONES, output);
        this.shapedHammer(ItemsRegistry.IRON_HAMMER, (ItemLike)Items.IRON_INGOT, (TagKey<Item>)Tags.Items.INGOTS_IRON, output);
        this.shapedHammer(ItemsRegistry.GOLD_HAMMER, (ItemLike)Items.GOLD_INGOT, (TagKey<Item>)Tags.Items.INGOTS_GOLD, output);
        this.shapedHammer(ItemsRegistry.DIAMOND_HAMMER, (ItemLike)Items.DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, output);
        this.shapedHammer(ItemsRegistry.NETHERITE_HAMMER, (ItemLike)Items.NETHERITE_INGOT, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, output);
        RecipesGenerator.shaped(BlocksRegistry.IRON_AUTO_HAMMER, (ItemLike)ItemsRegistry.IRON_AUTO_HAMMER.get(), "IGI/XHX/RGR", new Object[]{Character.valueOf('I'), Tags.Items.INGOTS_IRON, Character.valueOf('X'), Tags.Items.GLASS_BLOCKS, Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('G'), Tags.Items.INGOTS_GOLD, Character.valueOf('H'), ItemsRegistry.IRON_HAMMER.get()}).save(output);
        this.shapedAutoHammer(BlocksRegistry.GOLD_AUTO_HAMMER, BlocksRegistry.IRON_AUTO_HAMMER, ItemsRegistry.GOLD_HAMMER, output);
        this.shapedAutoHammer(BlocksRegistry.DIAMOND_AUTO_HAMMER, BlocksRegistry.GOLD_AUTO_HAMMER, ItemsRegistry.DIAMOND_HAMMER, output);
        this.shapedAutoHammer(BlocksRegistry.NETHERITE_AUTO_HAMMER, BlocksRegistry.DIAMOND_AUTO_HAMMER, ItemsRegistry.NETHERITE_HAMMER, output);
        BlocksRegistry.compressedBlockTranslations().keySet().forEach(id -> this.compressedBlockRecipe(output, (String)id));
        this.temperedJarRecipes(output);
        this.temperatureSourceRecipes(output);
        this.dripperRecipes(output);
        this.woodenBasinRecipes(output);
        this.crookRecipes(output);
        this.sluiceRecipes(output);
        this.hammerRecipes(output);
        this.fusingMachineRecipes(output);
        this.superCoolerRecipes(output);
    }

    private void compressedBlockRecipe(RecipeOutput output, String id) {
        BlocksRegistry.compressedBlocks(id).forEach(block -> {
            Block baseBlock = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.withDefaultNamespace((String)id)).orElseGet(() -> (Block)BuiltInRegistries.BLOCK.getOptional(FTBStuffNThings.id(id)).orElseThrow());
            Block prevBlock = null;
            String path = block.getId().getPath();
            char lastChr = path.charAt(path.length() - 1);
            if (Character.isDigit(lastChr)) {
                int n = Character.getNumericValue(lastChr);
                if (n > 2) {
                    prevBlock = (Block)BuiltInRegistries.BLOCK.getOptional(FTBStuffNThings.id("compressed_" + id + "_" + (n - 1))).orElseThrow();
                } else if (n == 2) {
                    prevBlock = (Block)BuiltInRegistries.BLOCK.getOptional(FTBStuffNThings.id("compressed_" + id)).orElseThrow();
                }
            }
            prevBlock = Objects.requireNonNullElse(prevBlock, baseBlock);
            RecipesGenerator.shaped((Block)block.get(), baseBlock, "AAA/AAA/AAA", Character.valueOf('A'), prevBlock).save(output, FTBStuffNThings.id("compressed/" + block.getId().getPath() + "_3x3"));
            RecipesGenerator.shapeless(prevBlock, 9, baseBlock, block.get()).save(output, FTBStuffNThings.id("compressed/" + BuiltInRegistries.BLOCK.getKey((Object)prevBlock).getPath() + "_shapeless"));
        });
    }

    private void shapedAutoHammer(DeferredBlock<AutoHammerBlock> result, DeferredBlock<AutoHammerBlock> prevAutoHammer, DeferredItem<HammerItem> hammer, RecipeOutput output) {
        RecipesGenerator.shaped(result, prevAutoHammer, "ITI/XCX/RGR", new Object[]{Character.valueOf('I'), Tags.Items.INGOTS_IRON, Character.valueOf('X'), Tags.Items.GLASS_BLOCKS, Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE, Character.valueOf('G'), Tags.Items.INGOTS_GOLD, Character.valueOf('T'), hammer.asItem(), Character.valueOf('C'), prevAutoHammer.asItem()}).save(output);
    }

    private void shapedHammer(DeferredItem<HammerItem> result, ItemLike head, RecipeOutput output) {
        RecipesGenerator.shaped(result, head, "HRH/ R / R ", new Object[]{Character.valueOf('H'), head.asItem(), Character.valueOf('R'), Tags.Items.RODS_WOODEN}).save(output);
    }

    private void shapedHammer(DeferredItem<HammerItem> result, ItemLike required, TagKey<Item> head, RecipeOutput output) {
        RecipesGenerator.shaped(result, required, "HRH/ R / R ", new Object[]{Character.valueOf('H'), head, Character.valueOf('R'), Tags.Items.RODS_WOODEN}).save(output);
    }

    private void waterStrainer(DeferredBlock<WaterStrainerBlock> result, Block plankBlock, RecipeOutput output) {
        RecipesGenerator.shaped(result, (ItemLike)ItemsRegistry.CLOTH_MESH.get(), "S S/M M/PMP", new Object[]{Character.valueOf('S'), Tags.Items.RODS_WOODEN, Character.valueOf('M'), ItemsRegistry.CLOTH_MESH, Character.valueOf('P'), plankBlock}).save(output);
    }

    private void woodSluice(DeferredBlock<SluiceBlock> result, Block woodType, RecipeOutput output) {
        RecipesGenerator.shaped(result, Items.STICK, "WS/WW", new Object[]{Character.valueOf('W'), woodType, Character.valueOf('S'), Tags.Items.RODS_WOODEN}).save(output);
    }

    private void temperedJarRecipes(RecipeOutput output) {
        RecipesGenerator.temperedJar(List.of(SizedIngredient.of((TagKey)Tags.Items.COBBLESTONES, (int)4)), List.of(), List.of(), List.of(new FluidStack((Fluid)Fluids.LAVA, 10)), Temperature.SUPERHEATED).saveTest(output, FTBStuffNThings.id("cobble_to_lava"));
        RecipesGenerator.temperedJar(List.of(SizedIngredient.of((TagKey)Tags.Items.DUSTS_REDSTONE, (int)1)), List.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)1000)), List.of(), List.of(new FluidStack((Fluid)Fluids.LAVA, 1000)), Temperature.HOT).saveTest(output, FTBStuffNThings.id("redstone_to_lava"));
        RecipesGenerator.temperedJar(List.of(SizedIngredient.of((TagKey)Tags.Items.DUSTS_REDSTONE, (int)8)), List.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)8000)), List.of(), List.of(new FluidStack((Fluid)Fluids.LAVA, 8000)), Temperature.HOT).saveTest(output, FTBStuffNThings.id("redstone_to_lava_x8"));
        RecipesGenerator.temperedJar(List.of(SizedIngredient.of((TagKey)Tags.Items.DUSTS_REDSTONE, (int)1), SizedIngredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE, (int)1)), List.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)1000)), List.of(), List.of(new FluidStack((Fluid)Fluids.LAVA, 2000)), Temperature.HOT).saveTest(output, FTBStuffNThings.id("redstone_glowstone_to_lava"));
        RecipesGenerator.temperedJar(List.of(), List.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)1000), SizedFluidIngredient.of((Fluid)Fluids.LAVA, (int)1000)), List.of(new ItemStack((ItemLike)Items.OBSIDIAN)), List.of(), Temperature.NORMAL, 60).saveTest(output, FTBStuffNThings.id("obsidian"));
        RecipesGenerator.temperedJar(List.of(SizedIngredient.of((ItemLike)Items.SUGAR, (int)1)), List.of(SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)1000)), List.of(new ItemStack((ItemLike)Blocks.GLASS, 4)), List.of(), Temperature.CHILLED).saveTest(output, FTBStuffNThings.id("sugar_glass"));
    }

    private void temperatureSourceRecipes(RecipeOutput output) {
        new TemperatureSourceRecipeBuilder(Blocks.STONE, Temperature.NORMAL, 1.0).withDisplayItem((ItemStack)Util.make((Object)Blocks.STONE.asItem().getDefaultInstance(), stack -> stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"ftbstuff.any_block")))).save(output, FTBStuffNThings.id("any_block"));
        new TemperatureSourceRecipeBuilder(Blocks.BEACON, Temperature.SUPERHEATED, 4.0).save(output, FTBStuffNThings.id("beacon"));
        new TemperatureSourceRecipeBuilder(Blocks.BLUE_ICE, Temperature.CHILLED, 4.0).save(output, FTBStuffNThings.id("blue_ice"));
        new TemperatureSourceRecipeBuilder((Block)BlocksRegistry.BLUE_MAGMA_BLOCK.get(), Temperature.SUPERHEATED, 4.0).save(output, FTBStuffNThings.id("blue_magma_block"));
        new TemperatureSourceRecipeBuilder("minecraft:campfire[lit=true]", Temperature.HOT, 0.5).save(output, FTBStuffNThings.id("campfire"));
        new TemperatureSourceRecipeBuilder((Block)BlocksRegistry.CREATIVE_SUPERHEATED_TEMPERATURE_SOURCE.get(), Temperature.SUPERHEATED, 100.0).hideFromJEI().save(output, FTBStuffNThings.id("creative_high"));
        new TemperatureSourceRecipeBuilder((Block)BlocksRegistry.CREATIVE_HOT_TEMPERATURE_SOURCE.get(), Temperature.HOT, 100.0).hideFromJEI().save(output, FTBStuffNThings.id("creative_low"));
        new TemperatureSourceRecipeBuilder((Block)BlocksRegistry.CREATIVE_CHILLED_TEMPERATURE_SOURCE.get(), Temperature.CHILLED, 100.0).hideFromJEI().save(output, FTBStuffNThings.id("creative_subzero"));
        new TemperatureSourceRecipeBuilder(Blocks.CRYING_OBSIDIAN, Temperature.NORMAL, 3.0).save(output, FTBStuffNThings.id("crying_obsidian"));
        new TemperatureSourceRecipeBuilder(Blocks.FIRE, Temperature.HOT, 0.75).withDisplayItem((ItemStack)Util.make((Object)Items.FLINT_AND_STEEL.getDefaultInstance(), stack -> stack.set(DataComponents.CUSTOM_NAME, (Object)Blocks.FIRE.getName()))).save(output, FTBStuffNThings.id("fire"));
        new TemperatureSourceRecipeBuilder(Blocks.GLOWSTONE, Temperature.NORMAL, 1.25).save(output, FTBStuffNThings.id("glowstone"));
        new TemperatureSourceRecipeBuilder(Blocks.ICE, Temperature.CHILLED, 0.25).save(output, FTBStuffNThings.id("ice"));
        new TemperatureSourceRecipeBuilder(Blocks.LAVA, Temperature.HOT, 4.0).withDisplayItem(Items.LAVA_BUCKET.getDefaultInstance()).save(output, FTBStuffNThings.id("lava"));
        new TemperatureSourceRecipeBuilder(Blocks.MAGMA_BLOCK, Temperature.HOT, 1.0).save(output, FTBStuffNThings.id("magma_block"));
        new TemperatureSourceRecipeBuilder(Blocks.PACKED_ICE, Temperature.CHILLED, 1.0).save(output, FTBStuffNThings.id("packed_ice"));
        new TemperatureSourceRecipeBuilder(Blocks.RESPAWN_ANCHOR, Temperature.NORMAL, 8.0).save(output, FTBStuffNThings.id("respawn_anchor"));
        new TemperatureSourceRecipeBuilder("minecraft:soul_campfire[lit=true]", Temperature.SUPERHEATED, 0.5).save(output, FTBStuffNThings.id("soul_campfire"));
        new TemperatureSourceRecipeBuilder(Blocks.SOUL_FIRE, Temperature.SUPERHEATED, 0.75).withDisplayItem((ItemStack)Util.make((Object)Items.FLINT_AND_STEEL.getDefaultInstance(), stack -> stack.set(DataComponents.CUSTOM_NAME, (Object)Blocks.SOUL_FIRE.getName()))).save(output, FTBStuffNThings.id("soul_fire"));
        new TemperatureSourceRecipeBuilder(Blocks.TORCH, Temperature.HOT, 0.25).save(output, FTBStuffNThings.id("torch"));
        new TemperatureSourceRecipeBuilder(Blocks.WALL_TORCH, Temperature.HOT, 0.25).hideFromJEI().save(output, FTBStuffNThings.id("wall_torch"));
    }

    private void dripperRecipes(RecipeOutput output) {
        new DripperRecipeBuilder(RecipesGenerator.stateStr(Blocks.DIRT), RecipesGenerator.stateStr(Blocks.MUD), new FluidStack((Fluid)Fluids.WATER, 50)).withChance(0.2).saveTest(output.withConditions(new ICondition[]{DevEnvironmentCondition.INSTANCE}), FTBStuffNThings.id("dirt_to_mud"));
        new DripperRecipeBuilder(RecipesGenerator.stateStr(Blocks.IRON_BLOCK), RecipesGenerator.stateStr(Blocks.GOLD_BLOCK), new FluidStack((Fluid)Fluids.LAVA, 250)).withChance(0.01).saveTest(output, FTBStuffNThings.id("iron_to_gold"));
        new DripperRecipeBuilder(RecipesGenerator.stateStr(Blocks.SAND), RecipesGenerator.stateStr(Blocks.CLAY), new FluidStack((Fluid)Fluids.WATER, 5)).withChance(0.1).consumeFluidOnFail().saveTest(output, FTBStuffNThings.id("sand_to_clay"));
        new DripperRecipeBuilder("minecraft:campfire[lit=false]", "minecraft:campfire[lit=true]", new FluidStack((Fluid)Fluids.LAVA, 250)).withChance(0.5).saveTest(output, FTBStuffNThings.id("campfire_lighting"));
        new DripperRecipeBuilder("#minecraft:leaves", RecipesGenerator.stateStr(Blocks.WATER), new FluidStack((Fluid)Fluids.WATER, 500)).withChance(0.1).saveTest(output, FTBStuffNThings.id("leaves_to_water"));
    }

    private void woodenBasinRecipes(RecipeOutput output) {
        new WoodenBasinRecipeBuilder("#minecraft:leaves", new FluidStack((Fluid)Fluids.WATER, 125)).withBlockConsumeChance(0.1f).saveTest(output, FTBStuffNThings.id("leaves_to_water"));
        new WoodenBasinRecipeBuilder("ftbstuff:blue_magma_block", new FluidStack((Fluid)Fluids.LAVA, 10)).withBlockConsumeChance(0.5f).dropItems().saveTest(output, FTBStuffNThings.id("blue_magma_to_lava"));
    }

    private void crookRecipes(RecipeOutput output) {
        new CrookRecipeBuilder(Ingredient.of((TagKey)ItemTags.LEAVES), List.of(new ItemWithChance(new ItemStack((ItemLike)Items.GOLD_NUGGET), 0.5), new ItemWithChance(new ItemStack((ItemLike)Items.IRON_NUGGET), 0.5))).saveTest(output, FTBStuffNThings.id("nuggets_from_leaves"));
        new CrookRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SHORT_GRASS}), List.of(new ItemWithChance(new ItemStack((ItemLike)Items.STRING), 0.5))).keepExistingDrops().saveTest(output, FTBStuffNThings.id("string_from_grass"));
    }

    private void sluiceRecipes(RecipeOutput output) {
        new SluiceRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE}), List.of(new ItemWithChance(new ItemStack((ItemLike)Blocks.GRAVEL), 1.0)), List.of(MeshType.CLOTH, MeshType.IRON)).saveTest(output, FTBStuffNThings.id("gravel_from_cobblestone"));
        new SluiceRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), List.of(new ItemWithChance(new ItemStack((ItemLike)Blocks.SAND), 0.5)), List.of(MeshType.CLOTH, MeshType.IRON, MeshType.DIAMOND)).fluid(new FluidStack((Fluid)Fluids.WATER, 1000)).saveTest(output, FTBStuffNThings.id("sand_from_gravel"));
        new SluiceRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_SAND}), List.of(new ItemWithChance(new ItemStack((ItemLike)Items.BLAZE_POWDER), 1.0)), List.of(MeshType.BLAZING)).saveTest(output, FTBStuffNThings.id("blaze_from_soul_sand"));
    }

    private void hammerRecipes(RecipeOutput output) {
        new HammerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE}), List.of(new ItemStack((ItemLike)Blocks.GRAVEL))).saveTest(output, FTBStuffNThings.id("gravel_from_cobblestone"));
        new HammerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), List.of(new ItemStack((ItemLike)Blocks.SAND))).saveTest(output, FTBStuffNThings.id("sand_from_gravel"));
        new HammerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND}), List.of(new ItemStack((ItemLike)BlocksRegistry.DUST_BLOCK.get()))).saveTest(output, FTBStuffNThings.id("dust_from_sand"));
        new HammerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLED_DEEPSLATE}), List.of(new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64), new ItemStack((ItemLike)Blocks.GRAVEL, 64))).saveTest(output, FTBStuffNThings.id("gravel_from_deepslate"));
        new HammerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BlocksRegistry.compressedBlocks("basalt").get(1)}), List.of(new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 64), new ItemStack((ItemLike)ItemsRegistry.CRUSHED_BASALT.get(), 25))).saveTest(output, FTBStuffNThings.id("crushed_basalt_2"));
    }

    private void fusingMachineRecipes(RecipeOutput output) {
        new FusingMachineRecipeBuilder(List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL})), new FluidStack((Fluid)Fluids.LAVA, 1000), 100, 60).saveTest(output, FTBStuffNThings.id("lava_from_cobble_gravel"));
        new FusingMachineRecipeBuilder(List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE})), new FluidStack((Fluid)Fluids.LAVA, 250), 50, 40).saveTest(output, FTBStuffNThings.id("lava_from_cobble"));
        new FusingMachineRecipeBuilder(List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE})), new FluidStack((Fluid)Fluids.WATER, 1000), 5, 20).saveTest(output, FTBStuffNThings.id("water_from_ice"));
    }

    private void superCoolerRecipes(RecipeOutput output) {
        new SuperCoolerRecipeBuilder(List.of(Ingredient.of((TagKey)ItemTags.SAND), Ingredient.of((TagKey)Tags.Items.GRAVELS), Ingredient.of((TagKey)Tags.Items.DYES_WHITE)), SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)1000), 50, 20, new ItemStack((ItemLike)Items.WHITE_CONCRETE, 2)).saveTest(output, FTBStuffNThings.id("white_concrete"));
        new SuperCoolerRecipeBuilder(List.of(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIRT})), SizedFluidIngredient.of((Fluid)Fluids.WATER, (int)100), 25, 40, new ItemStack((ItemLike)Items.MUD)).saveTest(output, FTBStuffNThings.id("mud"));
    }

    private static TemperedJarRecipeBuilder temperedJar(List<SizedIngredient> itemsIn, List<SizedFluidIngredient> fluidsIn, List<ItemStack> itemsOut, List<FluidStack> fluidsOut, Temperature requiredTemp) {
        return new TemperedJarRecipeBuilder(itemsIn, fluidsIn, itemsOut, fluidsOut, requiredTemp);
    }

    private static TemperedJarRecipeBuilder temperedJar(List<SizedIngredient> itemsIn, List<SizedFluidIngredient> fluidsIn, List<ItemStack> itemsOut, List<FluidStack> fluidsOut, Temperature requiredTemp, int time) {
        return new TemperedJarRecipeBuilder(itemsIn, fluidsIn, itemsOut, fluidsOut, requiredTemp).withTime(time);
    }

    private static <T extends ItemLike> ShapedRecipeBuilder shaped(T result, T required, String pattern, Object ... keys) {
        return RecipesGenerator.shaped(result, 1, required, pattern, keys);
    }

    private static <T extends ItemLike> ShapedRecipeBuilder shaped(T result, int count, T required, String pattern, Object ... keys) {
        ShapedRecipeBuilder b = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, result, (int)count);
        Arrays.stream(pattern.split("/")).forEach(arg_0 -> ((ShapedRecipeBuilder)b).pattern(arg_0));
        block5: for (int i = 0; i < keys.length; i += 2) {
            Object v;
            Object object = v = keys[i + 1];
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TagKey.class, ItemLike.class, Ingredient.class}, (Object)object, n)) {
                case 0: {
                    TagKey tagKey = (TagKey)object;
                    b.define((Character)keys[i], (TagKey)v);
                    continue block5;
                }
                case 1: {
                    ItemLike itemLike = (ItemLike)object;
                    b.define((Character)keys[i], itemLike);
                    continue block5;
                }
                case 2: {
                    Ingredient ingredient = (Ingredient)object;
                    b.define((Character)keys[i], ingredient);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("bad type for recipe ingredient " + String.valueOf(v));
                }
            }
        }
        b.unlockedBy("has_" + RecipesGenerator.safeName(required), RecipesGenerator.has(required));
        return b;
    }

    private static <T extends ItemLike> ShapelessRecipeBuilder shapeless(T result, T required, Object ... ingredients) {
        return RecipesGenerator.shapeless(result, 1, required, ingredients);
    }

    private static <T extends ItemLike> ShapelessRecipeBuilder shapeless(T result, int count, T required, Object ... ingredients) {
        return RecipesGenerator._shapeless(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, result, (int)count), required, ingredients);
    }

    private <T extends ItemLike> ShapelessRecipeBuilder shapelessStack(ItemStack result, T required, Object ... ingredients) {
        return RecipesGenerator._shapeless(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemStack)result), required, ingredients);
    }

    private static <T extends ItemLike> ShapelessRecipeBuilder _shapeless(ShapelessRecipeBuilder b, T required, Object ... ingredients) {
        if (ingredients.length == 0) {
            ingredients = new Object[]{required};
        }
        Object[] objectArray = ingredients;
        int n = objectArray.length;
        block5: for (int i = 0; i < n; ++i) {
            Object v;
            Object object = v = objectArray[i];
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TagKey.class, ItemLike.class, Ingredient.class}, (Object)object, n2)) {
                case 0: {
                    TagKey ignored = (TagKey)object;
                    b.requires((TagKey)v);
                    continue block5;
                }
                case 1: {
                    ItemLike itemLike = (ItemLike)object;
                    b.requires(itemLike);
                    continue block5;
                }
                case 2: {
                    Ingredient ingredient = (Ingredient)object;
                    b.requires(ingredient);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("bad type for recipe ingredient " + String.valueOf(v));
                }
            }
        }
        b.unlockedBy("has_" + RecipesGenerator.safeName(required), RecipesGenerator.has(required));
        return b;
    }

    private static <T extends ItemLike> String safeName(T itemLike) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem());
        return key.getPath().replace('/', '_');
    }

    private static String stateStr(BlockState state) {
        return BlockStateParser.serialize((BlockState)state);
    }

    private static String stateStr(Block block) {
        return BlockStateParser.serialize((BlockState)block.defaultBlockState());
    }
}

