/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SluiceRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BlockItem;

public class SluiceCategory
extends BaseStuffCategory<SluiceRecipe> {
    private static final Comparator<ItemWithChance> COMPARATOR = (a, b) -> (int)(b.chance() * 100.0 - a.chance() * 100.0);

    protected SluiceCategory() {
        super(RecipeTypes.SLUICE, (Component)Component.translatable((String)"ftbstuff.sluice"), (IDrawable)SluiceCategory.guiHelper().drawableBuilder(SluiceCategory.bgTexture("jei_sluice.png"), 0, 0, 156, 78).setTextureSize(180, 78).build(), SluiceCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((BlockItem)ItemsRegistry.OAK_SLUICE.get()).getDefaultInstance()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SluiceRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 5, 24).addItemStacks(recipe.getMeshTypes().stream().map(MeshType::getItemStack).toList());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 42).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, recipe.getFluid().map(f -> Arrays.asList(f.getFluids())).orElse(List.of()))).addRichTooltipCallback((recipeSlotView, tooltip) -> recipe.getFluid().ifPresent(f -> tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.fluid_usage", (Object[])new Object[]{Component.literal((String)("" + f.amount())).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY))));
        List<ItemWithChance> itemWithWeights = recipe.getResults().stream().sorted(COMPARATOR).toList();
        for (int i = 0; i < itemWithWeights.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 28 + i % 7 * 18, 5 + i / 7 * 24).addItemStack(itemWithWeights.get(i).item());
        }
    }

    @Override
    public void draw(SluiceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        ArrayList<ItemWithChance> itemWithWeights = new ArrayList<ItemWithChance>(recipe.getResults());
        itemWithWeights.sort(COMPARATOR);
        int row = 0;
        for (int i = 0; i < itemWithWeights.size(); ++i) {
            if (i > 0 && i % 7 == 0) {
                ++row;
            }
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)(36 + i % 7 * 18), 23.5f + (float)(row * 24), 100.0f);
            poseStack.scale(0.5f, 0.5f, 8000.0f);
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, Math.round(((ItemWithChance)itemWithWeights.get(i)).chance() * 100.0) + "%", 0, 0, 0xFFFFFF);
            poseStack.popPose();
        }
    }
}

