/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.wallalike;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum PumpComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation ID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag serverData = blockAccessor.getServerData();
        if (serverData.contains("timeLeft")) {
            iTooltip.add((Component)Component.translatable((String)"ftbstuff.jade.time_left", (Object[])new Object[]{PumpComponentProvider.getTimeString(serverData.getInt("timeLeft"))}));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof PumpBlockEntity) {
            PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
            compoundTag.putInt("timeLeft", pump.getTimeLeft());
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    private static String getTimeString(int ticks) {
        int seconds = ticks / 20;
        int i = seconds % 3600 / 60;
        return (String)(i > 0 ? i + "m " : "") + seconds % 3600 % 60 + "s";
    }

    static {
        ID = FTBStuffNThings.id("pump");
    }
}

