/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.items;

import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public class FluidCapsuleItem
extends Item {
    public FluidCapsuleItem() {
        super(new Item.Properties().component(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY).stacksTo(1));
    }

    public static ItemStack of(FluidStack fluidStack) {
        ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.FLUID_CAPSULE.get());
        stack.set(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)fluidStack));
        return stack;
    }

    public static FluidStack getFluid(ItemStack stack) {
        return ((SimpleFluidContent)stack.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        SimpleFluidContent content = (SimpleFluidContent)stack.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY);
        if (!content.isEmpty()) {
            tooltipComponents.add(MiscUtil.makeFluidStackDesc(content.copy()));
        }
    }

    public static class FluidHandler
    extends FluidHandlerItemStack.Consumable {
        public FluidHandler(ItemStack container) {
            super(ComponentsRegistry.STORED_FLUID, container, 1000);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.getFluid().isEmpty() ? super.fill(resource, doFill) : 0;
        }
    }
}

