/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.items;

import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class WaterBowlItem
extends Item {
    public WaterBowlItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static boolean fillBowl(Level level, Player player) {
        BlockHitResult hit = WaterBowlItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() == HitResult.Type.BLOCK && level.getBlockState(hit.getBlockPos()).getBlock() == Blocks.WATER) {
            player.awardStat(Stats.ITEM_USED.get((Object)Items.BOWL));
            player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @EventBusSubscriber(modid="ftbstuff")
    public static class Listener {
        @SubscribeEvent
        public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
            Player player = event.getEntity();
            if (event.getItemStack().getItem() == Items.BOWL && WaterBowlItem.fillBowl(event.getLevel(), player)) {
                event.getItemStack().shrink(1);
                if (!event.getLevel().isClientSide()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ItemsRegistry.WATER_BOWL.toStack(), (int)player.getInventory().selected);
                }
                player.swing(event.getHand());
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
                event.setCanceled(true);
            }
        }
    }

    public static class WaterBowlFluidHandler
    extends FluidHandlerItemStack.SwapEmpty {
        protected static final int BOWL_CAPACITY = 250;

        public WaterBowlFluidHandler(ItemStack container) {
            super(ComponentsRegistry.STORED_FLUID, container, new ItemStack((ItemLike)Items.BOWL), 250);
            this.setFluid(new FluidStack((Fluid)Fluids.WATER, 250));
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return fluid.getFluid() == Fluids.WATER;
        }
    }
}

