/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.registry;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbstuffnthings.blocks.SimpleFallingBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.BasaltgenProperties;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.CobblegenBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.cobblegen.CobblegenProperties;
import dev.ftb.mods.ftbstuffnthings.blocks.dripper.DripperBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.fusingmachine.FusingMachineBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerProperties;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.CreativeTemperatureSourceBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.JarAutomaterBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.JarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.BarrelBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.CrateBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.lootdroppers.SmallCrateBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.pump.PumpBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceType;
import dev.ftb.mods.ftbstuffnthings.blocks.strainer.WaterStrainerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.supercooler.SuperCoolerBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.tube.TubeBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.woodbasin.WoodenBasinBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class BlocksRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ftbstuff");
    public static final DeferredBlock<SluiceBlock> OAK_SLUICE = BLOCKS.register("oak_sluice", () -> new SluiceBlock(SluiceType.OAK, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> SPRUCE_SLUICE = BLOCKS.register("spruce_sluice", () -> new SluiceBlock(SluiceType.SPRUCE, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> BIRCH_SLUICE = BLOCKS.register("birch_sluice", () -> new SluiceBlock(SluiceType.BIRCH, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> JUNGLE_SLUICE = BLOCKS.register("jungle_sluice", () -> new SluiceBlock(SluiceType.JUNGLE, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> ACACIA_SLUICE = BLOCKS.register("acacia_sluice", () -> new SluiceBlock(SluiceType.ACACIA, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> DARK_OAK_SLUICE = BLOCKS.register("dark_oak_sluice", () -> new SluiceBlock(SluiceType.DARK_OAK, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> MANGROVE_SLUICE = BLOCKS.register("mangrove_sluice", () -> new SluiceBlock(SluiceType.MANGROVE, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> CHERRY_SLUICE = BLOCKS.register("cherry_sluice", () -> new SluiceBlock(SluiceType.CHERRY, SoundType.CHERRY_WOOD));
    public static final DeferredBlock<SluiceBlock> PALE_OAK_SLUICE = BLOCKS.register("pale_oak_sluice", () -> new SluiceBlock(SluiceType.PALE_OAK, SoundType.WOOD));
    public static final DeferredBlock<SluiceBlock> CRIMSON_SLUICE = BLOCKS.register("crimson_sluice", () -> new SluiceBlock(SluiceType.CRIMSON, SoundType.NETHER_WOOD));
    public static final DeferredBlock<SluiceBlock> WARPED_SLUICE = BLOCKS.register("warped_sluice", () -> new SluiceBlock(SluiceType.WARPED, SoundType.NETHER_WOOD));
    public static final DeferredBlock<SluiceBlock> BAMBOO_SLUICE = BLOCKS.register("bamboo_sluice", () -> new SluiceBlock(SluiceType.BAMBOO, SoundType.BAMBOO_WOOD));
    public static final DeferredBlock<SluiceBlock> IRON_SLUICE = BLOCKS.register("iron_sluice", () -> new SluiceBlock(SluiceType.IRON, SoundType.METAL));
    public static final DeferredBlock<SluiceBlock> DIAMOND_SLUICE = BLOCKS.register("diamond_sluice", () -> new SluiceBlock(SluiceType.DIAMOND, SoundType.METAL));
    public static final DeferredBlock<SluiceBlock> NETHERITE_SLUICE = BLOCKS.register("netherite_sluice", () -> new SluiceBlock(SluiceType.NETHERITE, SoundType.NETHERITE_BLOCK));
    public static final List<DeferredBlock<SluiceBlock>> WOODEN_SLUICE = List.of(OAK_SLUICE, SPRUCE_SLUICE, BIRCH_SLUICE, JUNGLE_SLUICE, ACACIA_SLUICE, DARK_OAK_SLUICE, MANGROVE_SLUICE, CHERRY_SLUICE, PALE_OAK_SLUICE, CRIMSON_SLUICE, WARPED_SLUICE, BAMBOO_SLUICE);
    public static final List<DeferredBlock<SluiceBlock>> ALL_SLUICES = List.of(OAK_SLUICE, SPRUCE_SLUICE, BIRCH_SLUICE, JUNGLE_SLUICE, ACACIA_SLUICE, DARK_OAK_SLUICE, MANGROVE_SLUICE, CHERRY_SLUICE, PALE_OAK_SLUICE, CRIMSON_SLUICE, WARPED_SLUICE, BAMBOO_SLUICE, IRON_SLUICE, DIAMOND_SLUICE, NETHERITE_SLUICE);
    public static final DeferredBlock<AutoHammerBlock> IRON_AUTO_HAMMER = BLOCKS.register("iron_auto_hammer", () -> new AutoHammerBlock(AutoHammerProperties.IRON));
    public static final DeferredBlock<AutoHammerBlock> GOLD_AUTO_HAMMER = BLOCKS.register("gold_auto_hammer", () -> new AutoHammerBlock(AutoHammerProperties.GOLD));
    public static final DeferredBlock<AutoHammerBlock> DIAMOND_AUTO_HAMMER = BLOCKS.register("diamond_auto_hammer", () -> new AutoHammerBlock(AutoHammerProperties.DIAMOND));
    public static final DeferredBlock<AutoHammerBlock> NETHERITE_AUTO_HAMMER = BLOCKS.register("netherite_auto_hammer", () -> new AutoHammerBlock(AutoHammerProperties.NETHERITE));
    public static final List<DeferredBlock<AutoHammerBlock>> ALL_AUTO_HAMMERS = List.of(IRON_AUTO_HAMMER, GOLD_AUTO_HAMMER, DIAMOND_AUTO_HAMMER, NETHERITE_AUTO_HAMMER);
    public static final DeferredBlock<CobblegenBlock> STONE_COBBLESTONE_GENERATOR = BLOCKS.register("stone_cobblestone_generator", () -> new CobblegenBlock(CobblegenProperties.STONE));
    public static final DeferredBlock<CobblegenBlock> IRON_COBBLESTONE_GENERATOR = BLOCKS.register("iron_cobblestone_generator", () -> new CobblegenBlock(CobblegenProperties.IRON));
    public static final DeferredBlock<CobblegenBlock> GOLD_COBBLESTONE_GENERATOR = BLOCKS.register("gold_cobblestone_generator", () -> new CobblegenBlock(CobblegenProperties.GOLD));
    public static final DeferredBlock<CobblegenBlock> DIAMOND_COBBLESTONE_GENERATOR = BLOCKS.register("diamond_cobblestone_generator", () -> new CobblegenBlock(CobblegenProperties.DIAMOND));
    public static final DeferredBlock<CobblegenBlock> NETHERITE_COBBLESTONE_GENERATOR = BLOCKS.register("netherite_cobblestone_generator", () -> new CobblegenBlock(CobblegenProperties.NETHERITE));
    public static final DeferredBlock<CobblegenBlock> STONE_BASALT_GENERATOR = BLOCKS.register("stone_basalt_generator", () -> new CobblegenBlock(BasaltgenProperties.STONE));
    public static final DeferredBlock<CobblegenBlock> IRON_BASALT_GENERATOR = BLOCKS.register("iron_basalt_generator", () -> new CobblegenBlock(BasaltgenProperties.IRON));
    public static final DeferredBlock<CobblegenBlock> GOLD_BASALT_GENERATOR = BLOCKS.register("gold_basalt_generator", () -> new CobblegenBlock(BasaltgenProperties.GOLD));
    public static final DeferredBlock<CobblegenBlock> DIAMOND_BASALT_GENERATOR = BLOCKS.register("diamond_basalt_generator", () -> new CobblegenBlock(BasaltgenProperties.DIAMOND));
    public static final DeferredBlock<CobblegenBlock> NETHERITE_BASALT_GENERATOR = BLOCKS.register("netherite_basalt_generator", () -> new CobblegenBlock(BasaltgenProperties.NETHERITE));
    public static final List<DeferredBlock<CobblegenBlock>> COBBLEGENS = List.of(STONE_COBBLESTONE_GENERATOR, IRON_COBBLESTONE_GENERATOR, GOLD_COBBLESTONE_GENERATOR, DIAMOND_COBBLESTONE_GENERATOR, NETHERITE_COBBLESTONE_GENERATOR);
    public static final List<DeferredBlock<CobblegenBlock>> BASALTGENS = List.of(STONE_BASALT_GENERATOR, IRON_BASALT_GENERATOR, GOLD_BASALT_GENERATOR, DIAMOND_BASALT_GENERATOR, NETHERITE_BASALT_GENERATOR);
    public static final DeferredBlock<PumpBlock> PUMP = BLOCKS.register("pump", PumpBlock::new);
    public static final DeferredBlock<DripperBlock> DRIPPER = BLOCKS.register("dripper", DripperBlock::new);
    public static final DeferredBlock<WoodenBasinBlock> WOODEN_BASIN = BLOCKS.register("wooden_basin", WoodenBasinBlock::new);
    public static final DeferredBlock<FusingMachineBlock> FUSING_MACHINE = BLOCKS.register("fusing_machine", FusingMachineBlock::new);
    public static final DeferredBlock<SuperCoolerBlock> SUPER_COOLER = BLOCKS.register("super_cooler", SuperCoolerBlock::new);
    public static final DeferredBlock<TubeBlock> TUBE = BLOCKS.register("tube", TubeBlock::new);
    public static final DeferredBlock<JarBlock> JAR = BLOCKS.register("jar", JarBlock::new);
    public static final DeferredBlock<TemperedJarBlock> TEMPERED_JAR = BLOCKS.register("tempered_jar", TemperedJarBlock::new);
    public static final DeferredBlock<JarAutomaterBlock> JAR_AUTOMATER = BLOCKS.register("auto_processing_block", JarAutomaterBlock::new);
    public static final DeferredBlock<Block> BLUE_MAGMA_BLOCK = BLOCKS.register("blue_magma_block", () -> new MagmaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.NETHER).requiresCorrectToolForDrops().lightLevel(state -> 3).randomTicks().strength(0.5f).isValidSpawn((state, level, pos, entity) -> entity.fireImmune()).hasPostProcess((state, level, pos) -> true).emissiveRendering((state, level, pos) -> true)));
    public static final DeferredBlock<Block> CREATIVE_HOT_TEMPERATURE_SOURCE = BLOCKS.register("creative_low_temperature_source", CreativeTemperatureSourceBlock::new);
    public static final DeferredBlock<Block> CREATIVE_SUPERHEATED_TEMPERATURE_SOURCE = BLOCKS.register("creative_high_temperature_source", CreativeTemperatureSourceBlock::new);
    public static final DeferredBlock<Block> CREATIVE_CHILLED_TEMPERATURE_SOURCE = BLOCKS.register("creative_subzero_temperature_source", CreativeTemperatureSourceBlock::new);
    public static final DeferredBlock<Block> CAST_IRON_BLOCK = BLOCKS.registerBlock("cast_iron_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).sound(SoundType.METAL).requiresCorrectToolForDrops());
    public static final DeferredBlock<Block> DUST_BLOCK = BLOCKS.registerBlock("dust", SimpleFallingBlock::new, BlocksRegistry.dustBlockProperties());
    public static final DeferredBlock<Block> CRUSHED_NETHERRACK = BLOCKS.registerBlock("crushed_netherrack", SimpleFallingBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.NETHER).requiresCorrectToolForDrops().strength(0.35f).sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> CRUSHED_BASALT = BLOCKS.registerBlock("crushed_basalt", SimpleFallingBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(DyeColor.BLACK).requiresCorrectToolForDrops().strength(0.8f, 2.75f).sound(SoundType.BASALT));
    public static final DeferredBlock<Block> CRUSHED_ENDSTONE = BLOCKS.registerBlock("crushed_endstone", SimpleFallingBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.SAND).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final DeferredBlock<Block> WHITE_BARREL = BLOCKS.register("white_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> GREEN_BARREL = BLOCKS.register("green_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> BLUE_BARREL = BLOCKS.register("blue_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> PURPLE_BARREL = BLOCKS.register("purple_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> RED_BARREL = BLOCKS.register("red_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> BLACK_BARREL = BLOCKS.register("black_barrel", BarrelBlock::new);
    public static final DeferredBlock<Block> GOLDEN_BARREL = BLOCKS.register("golden_barrel", BarrelBlock::new);
    public static final List<DeferredBlock<Block>> BARRELS = List.of(WHITE_BARREL, GREEN_BARREL, BLUE_BARREL, PURPLE_BARREL, RED_BARREL, BLACK_BARREL, GOLDEN_BARREL);
    public static final DeferredBlock<Block> SMALL_CRATE = BLOCKS.register("small_crate", SmallCrateBlock::new);
    public static final DeferredBlock<Block> CRATE = BLOCKS.register("crate", CrateBlock::new);
    public static final DeferredBlock<Block> PULSATING_CRATE = BLOCKS.register("pulsating_crate", CrateBlock::new);
    public static final List<DeferredBlock<Block>> CRATES = List.of(SMALL_CRATE, CRATE, PULSATING_CRATE);
    private static final List<DeferredBlock<WaterStrainerBlock>> WATER_STRAINERS = new ArrayList<DeferredBlock<WaterStrainerBlock>>();
    public static final DeferredBlock<WaterStrainerBlock> ACACIA_STRAINER = BlocksRegistry.registerStrainer(WoodType.ACACIA);
    public static final DeferredBlock<WaterStrainerBlock> BAMBOO_STRAINER = BlocksRegistry.registerStrainer(WoodType.BAMBOO);
    public static final DeferredBlock<WaterStrainerBlock> BIRCH_STRAINER = BlocksRegistry.registerStrainer(WoodType.BIRCH);
    public static final DeferredBlock<WaterStrainerBlock> CHERRY_STRAINER = BlocksRegistry.registerStrainer(WoodType.CHERRY);
    public static final DeferredBlock<WaterStrainerBlock> CRIMSON_STRAINER = BlocksRegistry.registerStrainer(WoodType.CRIMSON);
    public static final DeferredBlock<WaterStrainerBlock> DARK_OAK_STRAINER = BlocksRegistry.registerStrainer(WoodType.DARK_OAK);
    public static final DeferredBlock<WaterStrainerBlock> JUNGLE_STRAINER = BlocksRegistry.registerStrainer(WoodType.JUNGLE);
    public static final DeferredBlock<WaterStrainerBlock> MANGROVE_STRAINER = BlocksRegistry.registerStrainer(WoodType.MANGROVE);
    public static final DeferredBlock<WaterStrainerBlock> OAK_STRAINER = BlocksRegistry.registerStrainer(WoodType.OAK);
    public static final DeferredBlock<WaterStrainerBlock> SPRUCE_STRAINER = BlocksRegistry.registerStrainer(WoodType.SPRUCE);
    public static final DeferredBlock<WaterStrainerBlock> WARPED_STRAINER = BlocksRegistry.registerStrainer(WoodType.WARPED);
    private static final List<DeferredBlock<Block>> ALL_COMPRESSED = new ArrayList<DeferredBlock<Block>>();
    private static final Map<String, List<DeferredBlock<Block>>> COMPRESSED_BY_NAME = new HashMap<String, List<DeferredBlock<Block>>>();
    private static final Map<String, String> COMPRESSED_XLATE = new HashMap<String, String>();
    private static final List<DeferredBlock<Block>> COMPRESSED_BASALTS = BlocksRegistry.registerCompressed("basalt", "Basalt", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BASALT), 1.25f, 3, RotatedPillarBlock::new);
    private static final List<DeferredBlock<Block>> COMPRESSED_CLAYS = BlocksRegistry.registerCompressed("clay", "Clay", Blocks.CLAY, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_COBBLESTONES = BlocksRegistry.registerCompressed("cobblestone", "Cobblestone", Blocks.COBBLESTONE, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_DIRTS = BlocksRegistry.registerCompressed("dirt", "Dirt", Blocks.DIRT, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_DUSTS = BlocksRegistry.registerCompressed("dust", "Dust", BlocksRegistry.dustBlockProperties(), 0.5f, 3, SimpleFallingBlock::new);
    private static final List<DeferredBlock<Block>> COMPRESSED_END_STONES = BlocksRegistry.registerCompressed("end_stone", "End Stone", Blocks.END_STONE, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_GRAVELS = BlocksRegistry.registerCompressed("gravel", "Gravel", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL), 0.6f, 3, properties -> new ColoredFallingBlock(new ColorRGBA(8420475), properties));
    private static final List<DeferredBlock<Block>> COMPRESSED_NETHERRACKS = BlocksRegistry.registerCompressed("netherrack", "Netherrack", Blocks.NETHERRACK, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_RED_SANDS = BlocksRegistry.registerCompressed("red_sand", "Red Sand", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_SAND), 0.5f, 3, properties -> new ColoredFallingBlock(new ColorRGBA(11098145), properties));
    private static final List<DeferredBlock<Block>> COMPRESSED_SANDS = BlocksRegistry.registerCompressed("sand", "Sand", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND), 0.5f, 3, properties -> new ColoredFallingBlock(new ColorRGBA(14406560), properties));
    private static final List<DeferredBlock<Block>> COMPRESSED_STONES = BlocksRegistry.registerCompressed("stone", "Stone", Blocks.STONE, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_SOUL_SANDS = BlocksRegistry.registerCompressed("soul_sand", "Soul Sand", Blocks.SOUL_SAND, 3);
    private static final List<DeferredBlock<Block>> COMPRESSED_SOUL_SOILS = BlocksRegistry.registerCompressed("soul_soil", "Soul Soil", Blocks.SOUL_SOIL, 3);

    public static Collection<DeferredBlock<WaterStrainerBlock>> waterStrainers() {
        return Collections.unmodifiableCollection(WATER_STRAINERS);
    }

    public static Collection<DeferredBlock<Block>> allCompressedBlocks() {
        return Collections.unmodifiableCollection(ALL_COMPRESSED);
    }

    public static Map<String, String> compressedBlockTranslations() {
        return Collections.unmodifiableMap(COMPRESSED_XLATE);
    }

    public static List<DeferredBlock<Block>> compressedBlocks(String name) {
        return COMPRESSED_BY_NAME.get(name);
    }

    private static DeferredBlock<WaterStrainerBlock> registerStrainer(WoodType type) {
        DeferredBlock block = BLOCKS.registerBlock(type.name() + "_water_strainer", props -> new WaterStrainerBlock((BlockBehaviour.Properties)props, type), WaterStrainerBlock.defaultProps());
        WATER_STRAINERS.add((DeferredBlock<WaterStrainerBlock>)block);
        return block;
    }

    private static List<DeferredBlock<Block>> registerCompressed(String baseName, String label, BlockBehaviour.Properties props, float baseDestroyTime, int maxLevel, Function<BlockBehaviour.Properties, Block> factory) {
        Validate.isTrue((maxLevel > 0 ? 1 : 0) != 0);
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (int level = 1; level <= maxLevel; ++level) {
            String name = String.format("compressed_%s%s", baseName, level > 1 ? "_" + level : "");
            DeferredBlock deferredBlock = BLOCKS.registerBlock(name, factory, props.destroyTime(baseDestroyTime + (float)level));
            ALL_COMPRESSED.add((DeferredBlock<Block>)deferredBlock);
            blocks.add((Object)deferredBlock);
        }
        ImmutableList result = blocks.build();
        COMPRESSED_BY_NAME.put(baseName, (List<DeferredBlock<Block>>)result);
        COMPRESSED_XLATE.put(baseName, label);
        return result;
    }

    private static List<DeferredBlock<Block>> registerCompressed(String baseName, String label, Block baseBlock, int maxLevel) {
        return BlocksRegistry.registerCompressed(baseName, label, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock), baseBlock.defaultDestroyTime(), maxLevel, Block::new);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BlockBehaviour.Properties dustBlockProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).strength(0.4f).sound(SoundType.SAND);
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
    }
}

