/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.tubes;

import dev.ftb.mods.ftbstuffnthings.blocks.tube.TubeBlockEntity;
import dev.ftb.mods.ftbstuffnthings.tubes.ConnectedHandlers;
import dev.ftb.mods.ftbstuffnthings.util.DirectionUtil;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

public enum TubeNetwork {
    INSTANCE;

    private final Map<ResourceKey<Level>, Map<BlockPos, ConnectedHandlers>> handlerMap = new HashMap<ResourceKey<Level>, Map<BlockPos, ConnectedHandlers>>();

    public static ConnectedHandlers getConnectedHandlers(BlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("only call this on the server!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map map = TubeNetwork.INSTANCE.handlerMap.computeIfAbsent((ResourceKey<Level>)blockEntity.getLevel().dimension(), k -> new HashMap());
        BlockPos pos = blockEntity.getBlockPos();
        return map.computeIfAbsent(pos, k -> TubeNetwork.walkTubeNetwork(serverLevel, pos.above()));
    }

    private static ConnectedHandlers walkTubeNetwork(ServerLevel level, BlockPos initialPos) {
        ConnectedHandlers conn = ConnectedHandlers.create();
        if (!TubeNetwork.isValidTubeBlock(level, initialPos, Direction.DOWN, level.getBlockState(initialPos))) {
            return conn;
        }
        HashSet<BlockPos> traversedPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>(List.of(initialPos));
        while (!pendingPositions.isEmpty()) {
            BlockPos pos = (BlockPos)pendingPositions.pop();
            for (Direction dir : DirectionUtil.VALUES) {
                BlockPos pos1;
                TubeBlockEntity tube;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof TubeBlockEntity && (tube = (TubeBlockEntity)blockEntity).isSideClosed(dir) || !level.isLoaded(pos1 = pos.relative(dir))) continue;
                BlockState state = level.getBlockState(pos1);
                Direction opposite = dir.getOpposite();
                if (TubeNetwork.isValidTubeBlock(level, pos, opposite, state) && traversedPositions.add(pos1)) {
                    pendingPositions.add(pos1);
                    continue;
                }
                conn.checkAndAddHandlers(level, pos1, opposite);
            }
        }
        return conn;
    }

    private static boolean isValidTubeBlock(ServerLevel level, BlockPos pos, Direction dir, BlockState blockState) {
        TubeBlockEntity tube;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof TubeBlockEntity && !(tube = (TubeBlockEntity)blockEntity).isSideClosed(dir);
    }

    @EventBusSubscriber(modid="ftbstuff")
    public static class Listener {
        @SubscribeEvent
        public static void onServerShutdown(ServerStoppingEvent ignored) {
            TubeNetwork.INSTANCE.handlerMap.clear();
        }
    }
}

