/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.util;

import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;

public class MiscUtil {
    public static NonNullList<ItemStack> getItemsInHandler(IItemHandler handler) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            items.add(stack);
        }
        return NonNullList.copyOf(items);
    }

    public static Component makeFluidStackDesc(FluidStack stack) {
        return Component.translatable((String)"ftbstuff.tooltip.fluid", (Object[])new Object[]{stack.getAmount(), stack.getHoverName()}).withStyle(ChatFormatting.AQUA);
    }

    public static DataResult<Double> validateChanceRange(double d) {
        return d > 0.0 && d <= 1.0 ? DataResult.success((Object)d) : DataResult.error(() -> "must be in range (0.0 -> 1.0]");
    }
}

