/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.construction.BaseConstructionAgent;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public enum BaseConstructionManager {
    INSTANCE;

    private final Map<UUID, BaseConstructionAgent> agents = new HashMap<UUID, BaseConstructionAgent>();

    public void begin(ServerPlayer player, BaseDefinition baseDefinition) throws CommandSyntaxException {
        if (this.agents.containsKey(player.getUUID())) {
            throw CommandUtils.CONSTRUCTION_IN_PROGRESS.create((Object)player.getUUID());
        }
        boolean isParty = FTBTeamsAPI.api().getManager().getTeamForPlayer(player).map(Team::isPartyTeam).orElse(false);
        if (isParty) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        player.displayClientMessage((Component)Component.translatable((String)"ftbteambases.message.creation_started").withStyle(ChatFormatting.GREEN), false);
        this.agents.put(player.getUUID(), new BaseConstructionAgent(player, baseDefinition));
    }

    public void tick(MinecraftServer server) {
        if (!this.agents.isEmpty()) {
            HashSet completed = new HashSet();
            this.agents.forEach((id, agent) -> {
                agent.tick();
                if (agent.isDone()) {
                    completed.add(id);
                }
            });
            completed.forEach(this.agents::remove);
        }
    }

    public boolean isConstructing(ServerPlayer player) {
        return this.agents.containsKey(player.getUUID());
    }
}

