/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StringProperty
extends TeamProperty<String> {
    private final Pattern pattern;

    public StringProperty(ResourceLocation id, Supplier<String> def, @Nullable Pattern pattern) {
        super(id, def);
        this.pattern = pattern;
    }

    public StringProperty(ResourceLocation id, Supplier<String> def) {
        this(id, def, null);
    }

    public StringProperty(ResourceLocation id, String def, @Nullable Pattern pattern) {
        this(id, () -> def, pattern);
    }

    public StringProperty(ResourceLocation id, String def) {
        this(id, () -> def);
    }

    static StringProperty fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String def = buf.readUtf(Short.MAX_VALUE);
        int flags = buf.readVarInt();
        String patVal = buf.readUtf(Short.MAX_VALUE);
        return new StringProperty(id, def, patVal.isEmpty() ? null : Pattern.compile(patVal, flags));
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.STRING;
    }

    @Override
    public Optional<String> fromString(String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            return Optional.of(string);
        }
        return Optional.empty();
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeUtf((String)this.getDefaultValue(), Short.MAX_VALUE);
        buf.writeVarInt(this.pattern == null ? 0 : this.pattern.flags());
        buf.writeUtf(this.pattern == null ? "" : this.pattern.pattern(), Short.MAX_VALUE);
    }

    @Override
    public ConfigValue<?> config(ConfigGroup config, TeamPropertyValue<String> value) {
        return config.addString(this.id.getPath(), value.getValue(), value::setValue, (String)this.getDefaultValue(), this.pattern);
    }
}

