/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import dev.ftb.mods.ftbunearthed.FTBUnearthedTags;
import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.crafting.AcceptabilityCache;
import dev.ftb.mods.ftbunearthed.crafting.RecipeCaches;
import dev.ftb.mods.ftbunearthed.crafting.recipe.UneartherRecipe;
import dev.ftb.mods.ftbunearthed.entity.Worker;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.menu.UneartherMenu;
import dev.ftb.mods.ftbunearthed.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import dev.ftb.mods.ftbunearthed.registry.ModEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModRecipes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UneartherCoreBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int OUTPUT_SLOTS = 9;
    private static final int IDLING = -1;
    private static final int COOLDOWN = 40;
    private static final int PROGRESS_MULT = 100;
    private static final TargetingConditions WORKER_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private final FoodHandler foodHandler = new FoodHandler(this);
    private final InputHandler inputHandler = new InputHandler();
    private final WorkerHandler workerHandler = new WorkerHandler(this);
    private final ToolHandler toolHandler = new ToolHandler(this);
    private final ItemStackHandler outputHandler = new OutputHandler();
    private final IItemHandler publicItemHandler = new PublicItemHandler();
    private static final AcceptabilityCache<Item> knownInputItems = new AcceptabilityCache();
    private static final AcceptabilityCache<Item> knownToolItems = new AcceptabilityCache();
    private UneartherRecipe currentRecipe = null;
    private boolean recheckRecipe = true;
    private int cooldownTimer = 0;
    private int progress = -1;
    private UUID workerID = Util.NIL_UUID;
    private final ContainerData dataAccess;
    private int processingTime;
    private int syncedProgress;
    private int foodBuffer;
    private int currentSpeedBoost = 0;
    private int clientProgress;
    private SyncedStatus syncedStatus = SyncedStatus.EMPTY;
    private SyncedStatus lastSynced = SyncedStatus.EMPTY;
    private boolean syncNeeded;

    public UneartherCoreBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.UNEARTHER_CORE.get(), blockPos, blockState);
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> UneartherCoreBlockEntity.this.processingTime;
                    case 1 -> UneartherCoreBlockEntity.this.syncedProgress;
                    case 2 -> UneartherCoreBlockEntity.this.foodBuffer;
                    default -> UneartherCoreBlockEntity.this.currentSpeedBoost;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        UneartherCoreBlockEntity.this.processingTime = value;
                        break;
                    }
                    case 1: {
                        UneartherCoreBlockEntity.this.syncedProgress = value;
                        break;
                    }
                    case 2: {
                        UneartherCoreBlockEntity.this.foodBuffer = value;
                        break;
                    }
                    default: {
                        UneartherCoreBlockEntity.this.currentSpeedBoost = value;
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public static void clearKnownItemCaches() {
        knownToolItems.clear();
        knownInputItems.clear();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = super.getUpdateTag(provider);
        this.lastSynced = SyncedStatus.create(this);
        compound.put("Status", (Tag)SyncedStatus.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.lastSynced).getOrThrow());
        return compound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.processClientSync(tag, provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.processClientSync(pkt.getTag(), lookupProvider);
    }

    private void processClientSync(CompoundTag tag, HolderLookup.Provider provider) {
        this.syncedStatus = (SyncedStatus)SyncedStatus.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("Status")).getOrThrow();
        this.clientProgress = 0;
    }

    @NotNull
    private ItemStack getToolStack() {
        return this.toolHandler.getStackInSlot(0);
    }

    public boolean hasSuperBrush() {
        return this.getToolStack().has(ModDataComponents.SUPER_BRUSH);
    }

    @NotNull
    private ItemStack getWorkerStack() {
        return this.workerHandler.getStackInSlot(0);
    }

    @NotNull
    public ItemStack getInputStack() {
        return this.inputHandler.getStackInSlot(0);
    }

    public void tickClient(Level level) {
        if (this.syncedStatus.active()) {
            if (this.clientProgress == 0) {
                level.playLocalSound(this.getBlockPos().above(), SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 0.6f, 1.0f, false);
            }
            this.clientProgress = (this.clientProgress + 1) % this.syncedStatus.processingTime();
            if (level.random.nextInt(8) == 0) {
                Direction d = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                Vec3 vec = Vec3.atBottomCenterOf((Vec3i)this.getBlockPos()).add((double)d.getStepX() * 0.5, 1.5, (double)d.getStepZ() * 0.5);
                level.addParticle((ParticleOptions)ParticleTypes.DUST_PLUME, vec.x + level.random.nextDouble() - 0.5, vec.y, vec.z + level.random.nextDouble() - 0.5, 0.0, -0.1, 0.0);
            }
        } else {
            this.clientProgress = 0;
        }
    }

    public void tickServer(ServerLevel level) {
        if (this.recheckRecipe) {
            this.currentRecipe = RecipeCaches.UNEARTHER.getCachedRecipe(this::searchForRecipe, this::genIngredientHash).map(RecipeHolder::value).orElse(null);
            this.processingTime = this.currentRecipe == null ? 0 : this.currentRecipe.getProcessingTime();
            this.recheckRecipe = false;
        }
        this.checkForEntity(level);
        if (level.getGameTime() % 20L == 0L) {
            this.processFoodSlot(level);
        }
        int prevProgress = this.progress;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        } else if (this.currentRecipe != null) {
            this.runOneWorkCycle(level);
        } else {
            this.progress = -1;
        }
        if (this.progress != prevProgress) {
            this.syncedProgress = this.progress / 100;
            this.setChanged();
            this.syncNeeded = true;
        }
        if (this.syncNeeded) {
            this.syncStatusToClients();
            this.syncNeeded = false;
        }
    }

    private void checkForEntity(ServerLevel level) {
        Object currentWorker = level.getEntity(this.workerID);
        Direction d = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!this.getWorkerStack().isEmpty() && currentWorker == null && this.workerID.equals(Util.NIL_UUID)) {
            WorkerToken.WorkerData workerData = WorkerToken.getWorkerData(this.getWorkerStack());
            if (workerData == null) {
                return;
            }
            Worker newWorker = new Worker(ModEntityTypes.WORKER.get(), (Level)level);
            newWorker.setVillagerData(workerData.toVillagerData());
            newWorker.setNoAi(true);
            newWorker.setPos(Vec3.atCenterOf((Vec3i)this.getBlockPos()).add((double)d.getStepX() * -0.5, 0.0, (double)d.getStepZ() * -0.5));
            newWorker.setYHeadRot(d.toYRot());
            level.addFreshEntity((Entity)newWorker);
            newWorker.setSilent(true);
            this.workerID = newWorker.getUUID();
            currentWorker = newWorker;
            level.playSound(null, this.getBlockPos().above(2), SoundEvents.VILLAGER_CELEBRATE, SoundSource.BLOCKS);
            this.setChanged();
            this.workerEntitySanityCheck(level);
        } else if (this.getWorkerStack().isEmpty() && currentWorker != null) {
            level.playSound(null, this.getBlockPos().above(2), SoundEvents.VILLAGER_NO, SoundSource.BLOCKS);
            currentWorker.discard();
            currentWorker = null;
            this.workerID = Util.NIL_UUID;
            this.setChanged();
        }
        if (currentWorker instanceof Worker) {
            WorkerToken.WorkerData workerData;
            Worker w = (Worker)((Object)currentWorker);
            w.setItemInHand(InteractionHand.MAIN_HAND, this.getToolStack().copy());
            Direction dir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (this.currentRecipe != null) {
                w.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atCenterOf((Vec3i)this.getBlockPos()).add((double)dir.getStepX(), 0.8, (double)dir.getStepZ()));
                w.setBusy(true);
            } else {
                if (level.random.nextInt(20) == 0) {
                    LivingEntity p = level.getNearestEntity(LivingEntity.class, WORKER_TARGETING, (LivingEntity)w, w.getX(), w.getY(), w.getZ(), w.getBoundingBox().inflate(8.0));
                    if (p != null) {
                        w.lookAt(EntityAnchorArgument.Anchor.EYES, p.getEyePosition());
                    } else {
                        w.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atCenterOf((Vec3i)this.getBlockPos()).add((double)dir.getStepX(), 1.5, (double)dir.getStepZ()));
                    }
                }
                w.setBusy(false);
            }
            if (!this.getWorkerStack().isEmpty() && (workerData = WorkerToken.getWorkerData(this.getWorkerStack())) != null) {
                VillagerData data1 = w.getVillagerData();
                VillagerData data2 = workerData.toVillagerData();
                if (data1.getProfession() != data2.getProfession() || data1.getLevel() != data2.getLevel() || data1.getType() != data2.getType()) {
                    w.setVillagerData(data2);
                }
            }
        }
    }

    private void workerEntitySanityCheck(ServerLevel level) {
        AABB box = new AABB(this.getBlockPos().above()).inflate(1.0);
        level.getEntities((Entity)null, box, e -> e instanceof Villager).forEach(e -> {
            if (!e.getUUID().equals(this.workerID)) {
                FTBUnearthed.LOGGER.warn("unexpected villager entity in unearther @ {}/{}: id={}, expected={}", new Object[]{level.dimension().location(), this.getBlockPos(), e.getUUID(), this.workerID});
                e.discard();
            }
        });
    }

    private void processFoodSlot(ServerLevel level) {
        FoodProperties props;
        ItemStack food;
        if (!this.getWorkerStack().isEmpty() && this.foodBuffer == 0 && !(food = this.foodHandler.getStackInSlot(0)).isEmpty() && (props = food.getFoodProperties(null)) != null) {
            int value = (int)(props.saturation() * 1200.0f);
            if (!food.is(FTBUnearthedTags.Items.UNLIMITED_FOOD_SOURCE)) {
                this.foodHandler.extractItem(0, 1, false);
            }
            this.foodBuffer = Math.min((Integer)ServerConfig.MAX_FOOD_BUFFER.get(), this.foodBuffer + value * (Integer)ServerConfig.FOOD_SATURATION_MULTIPLIER.get());
            this.currentSpeedBoost = props.nutrition() * (Integer)ServerConfig.FOOD_SPEED_BOOST_MULTIPLIER.get();
            level.playSound(null, this.getBlockPos().above(2), SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setChanged();
        }
    }

    private void runOneWorkCycle(ServerLevel level) {
        int internalProcessingTime = this.currentRecipe.getProcessingTime() * 100;
        if (this.progress < 0 || this.progress > internalProcessingTime) {
            this.progress = internalProcessingTime;
        }
        int step = 100;
        boolean superBrush = this.hasSuperBrush();
        int effectiveSpeedBoost = this.getEffectiveSpeedBoost();
        if (this.foodBuffer > 0 || superBrush) {
            step += effectiveSpeedBoost;
            if (!superBrush) {
                --this.foodBuffer;
            }
        }
        if (this.progress > 0) {
            this.progress = Math.max(0, this.progress - step);
            if (this.progress == 0) {
                ItemStack taken = this.inputHandler.extractItem(0, 1, true);
                if (taken.isEmpty() || !this.tryGenerateOutputs(level)) {
                    this.cooldownTimer = 40;
                    this.progress = -1;
                } else {
                    this.inputHandler.extractItem(0, 1, false);
                    this.progress = internalProcessingTime;
                    if (level.random.nextFloat() < this.currentRecipe.getDamageChance()) {
                        this.getToolStack().hurtAndBreak(1, level, null, item -> level.playSound(null, this.getBlockPos().above(2), item.getBreakingSound(), SoundSource.BLOCKS, 1.0f, 1.0f));
                    }
                    if (WorkerToken.addWorkerXP(this.workerHandler.getStackInSlot(0), 1)) {
                        this.workerLevelUp(level);
                    }
                }
            }
        }
    }

    private void workerLevelUp(ServerLevel level) {
        Vec3 vec = Vec3.atCenterOf((Vec3i)this.getBlockPos().above(2));
        RandomSource r = level.getRandom();
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, vec.x, vec.y, vec.z, 15, r.nextDouble() - 0.5, r.nextDouble() - 0.5, r.nextDouble() - 0.5, 0.05);
        level.playSound(null, this.getBlockPos().above(), SoundEvents.VILLAGER_CELEBRATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        Entity entity = level.getEntity(this.workerID);
        if (entity instanceof Villager) {
            Villager v = (Villager)entity;
            WorkerToken.WorkerData data = WorkerToken.getWorkerData(this.workerHandler.getStackInSlot(0));
            v.setVillagerData(data.toVillagerData());
        }
        this.recheckRecipe = true;
    }

    private Optional<RecipeHolder<UneartherRecipe>> searchForRecipe() {
        return RecipeCaches.sortedUneartherRecipes(this.level).stream().filter(holder -> ((UneartherRecipe)holder.value()).test(this.getInputStack(), this.getWorkerStack(), this.getToolStack())).findFirst();
    }

    private int genIngredientHash() {
        return Objects.hash(ItemStack.hashItemAndComponents((ItemStack)this.getInputStack()), ItemStack.hashItemAndComponents((ItemStack)this.getWorkerStack()), ItemStack.hashItemAndComponents((ItemStack)this.getToolStack()));
    }

    private boolean tryGenerateOutputs(ServerLevel level) {
        assert (this.currentRecipe != null);
        List<ItemStack> outputs = this.currentRecipe.generateOutputs(level.random);
        if (outputs.isEmpty()) {
            return true;
        }
        int[] slotCounts = new int[this.outputHandler.getSlots()];
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            slotCounts[i] = this.outputHandler.getStackInSlot(i).getCount();
        }
        for (ItemStack output : outputs) {
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputHandler, (ItemStack)output, (boolean)false);
            if (result.isEmpty()) continue;
            for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
                if (slotCounts[i] == 0) {
                    this.outputHandler.setStackInSlot(i, ItemStack.EMPTY);
                    continue;
                }
                this.outputHandler.getStackInSlot(i).setCount(slotCounts[i]);
            }
            return false;
        }
        this.setChanged();
        return true;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Input", (Tag)this.inputHandler.serializeNBT(registries));
        tag.put("Food", (Tag)this.foodHandler.serializeNBT(registries));
        tag.put("Worker", (Tag)this.workerHandler.serializeNBT(registries));
        tag.put("Tool", (Tag)this.toolHandler.serializeNBT(registries));
        tag.put("Output", (Tag)this.outputHandler.serializeNBT(registries));
        tag.putInt("Progress", this.progress);
        tag.putInt("FoodBuffer", this.foodBuffer);
        tag.putInt("SpeedBoost", this.currentSpeedBoost);
        if (this.workerID != Util.NIL_UUID) {
            tag.putUUID("WorkerID", this.workerID);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inputHandler.deserializeNBT(registries, tag.getCompound("Input"));
        this.foodHandler.deserializeNBT(registries, tag.getCompound("Food"));
        this.workerHandler.deserializeNBT(registries, tag.getCompound("Worker"));
        this.toolHandler.deserializeNBT(registries, tag.getCompound("Tool"));
        this.outputHandler.deserializeNBT(registries, tag.getCompound("Output"));
        this.progress = tag.getInt("Progress");
        this.foodBuffer = tag.getInt("FoodBuffer");
        this.currentSpeedBoost = tag.getInt("SpeedBoost");
        this.workerID = tag.contains("WorkerID") ? tag.getUUID("WorkerID") : Util.NIL_UUID;
    }

    public int getEffectiveSpeedBoost() {
        return this.hasSuperBrush() ? (Integer)ServerConfig.SUPER_BRUSH_SPEED_BOOST.get() : this.currentSpeedBoost;
    }

    public IItemHandler getWorkerHandler() {
        return this.workerHandler;
    }

    public IItemHandler getToolHandler() {
        return this.toolHandler;
    }

    public IItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public IItemHandler getFoodHandler() {
        return this.foodHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public IItemHandler getItemHandler() {
        return this.publicItemHandler;
    }

    public static boolean isKnownToolItem(Level level, ItemStack stack) {
        return knownToolItems.isAcceptable(stack.getItem(), () -> level.getRecipeManager().getAllRecipesFor(ModRecipes.UNEARTHER_TYPE.get()).stream().anyMatch(h -> ((UneartherRecipe)h.value()).getToolItem().test(stack)));
    }

    private static boolean isKnownInputItem(Level level, ItemStack stack) {
        return knownInputItems.isAcceptable(stack.getItem(), () -> level.getRecipeManager().getAllRecipesFor(ModRecipes.UNEARTHER_TYPE.get()).stream().anyMatch(h -> ((UneartherRecipe)h.value()).isValidInput(stack)));
    }

    public void setRemoved() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (!this.workerID.equals(Util.NIL_UUID) && (level = this.level) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.workerID)) != null) {
            this.level.playSound(null, this.getBlockPos().above(2), SoundEvents.VILLAGER_DEATH, SoundSource.BLOCKS);
            entity.discard();
        }
        super.setRemoved();
    }

    public void dropItemContents() {
        this.dropIfPresent(this.foodHandler.getStackInSlot(0));
        this.dropIfPresent(this.getInputStack());
        this.dropIfPresent(this.getWorkerStack());
        this.dropIfPresent(this.getToolStack());
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            this.dropIfPresent(this.outputHandler.getStackInSlot(i));
        }
    }

    private void dropIfPresent(ItemStack stack) {
        if (!stack.isEmpty()) {
            Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)stack);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.ftbunearthed.core");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new UneartherMenu(containerId, playerInventory, this.getBlockPos(), this.dataAccess);
    }

    public void syncStatusToClients() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.lastSynced.equals(SyncedStatus.create(this))) {
                serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public SyncedStatus getSyncedStatus() {
        return this.syncedStatus;
    }

    public int getClientBreakProgress() {
        if (this.syncedStatus.active()) {
            float pct = Mth.clamp((float)((float)this.clientProgress / (float)this.syncedStatus.processingTime()), (float)0.0f, (float)1.0f);
            return (int)(9.0f * pct);
        }
        return 0;
    }

    public Optional<UneartherRecipe> getCurrentRecipe() {
        return Optional.ofNullable(this.currentRecipe);
    }

    private class FoodHandler
    extends FilteredInsertOnlyHandler {
        public FoodHandler(UneartherCoreBlockEntity uneartherCoreBlockEntity) {
            super(stack -> stack.getFoodProperties(null) != null);
        }
    }

    private class InputHandler
    extends FilteredInsertOnlyHandler {
        private Item lastItem;

        public InputHandler() {
            super(stack -> UneartherCoreBlockEntity.isKnownInputItem(UneartherCoreBlockEntity.this.level, stack));
            this.lastItem = Items.AIR;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.getStackInSlot(slot).getItem() != this.lastItem) {
                this.lastItem = this.getStackInSlot(slot).getItem();
                UneartherCoreBlockEntity.this.syncNeeded = true;
            }
        }
    }

    private class WorkerHandler
    extends FilteredInsertOnlyHandler {
        public WorkerHandler(UneartherCoreBlockEntity uneartherCoreBlockEntity) {
            super(WorkerHandler::checkWorker);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        private static boolean checkWorker(ItemStack stack) {
            return WorkerToken.getWorkerData(stack).profession() != VillagerProfession.NONE;
        }
    }

    private class ToolHandler
    extends FilteredInsertOnlyHandler {
        public ToolHandler(UneartherCoreBlockEntity uneartherCoreBlockEntity) {
            super(stack -> UneartherCoreBlockEntity.isKnownToolItem(uneartherCoreBlockEntity.level, stack));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    private class OutputHandler
    extends ItemStackHandler {
        public OutputHandler() {
            super(9);
        }

        protected void onContentsChanged(int slot) {
            UneartherCoreBlockEntity.this.setChanged();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }
    }

    private class PublicItemHandler
    implements IItemHandler {
        private final IItemHandler[] inputHandlers;

        private PublicItemHandler() {
            this.inputHandlers = new IItemHandler[]{UneartherCoreBlockEntity.this.inputHandler, UneartherCoreBlockEntity.this.foodHandler, UneartherCoreBlockEntity.this.toolHandler};
        }

        public int getSlots() {
            return this.inputHandlers.length + UneartherCoreBlockEntity.this.outputHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < this.inputHandlers.length ? this.inputHandlers[slot].getStackInSlot(0) : UneartherCoreBlockEntity.this.outputHandler.getStackInSlot(slot - this.inputHandlers.length);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot < this.inputHandlers.length ? this.inputHandlers[slot].insertItem(0, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot < this.inputHandlers.length ? ItemStack.EMPTY : UneartherCoreBlockEntity.this.outputHandler.extractItem(slot - this.inputHandlers.length, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return slot < this.inputHandlers.length ? this.inputHandlers[slot].getSlotLimit(0) : UneartherCoreBlockEntity.this.outputHandler.getSlotLimit(slot - this.inputHandlers.length);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot < this.inputHandlers.length ? this.inputHandlers[slot].isItemValid(0, stack) : UneartherCoreBlockEntity.this.outputHandler.isItemValid(slot - this.inputHandlers.length, stack);
        }
    }

    public record SyncedStatus(BlockState blockState, int processingTime) {
        static final Codec<SyncedStatus> CODEC = RecordCodecBuilder.create((T builder) -> builder.group((App)BlockState.CODEC.fieldOf("block").forGetter(SyncedStatus::blockState), (App)Codec.INT.fieldOf("time").forGetter(SyncedStatus::processingTime)).apply((Applicative)builder, SyncedStatus::new));
        static final SyncedStatus EMPTY = new SyncedStatus(Blocks.AIR.defaultBlockState(), 0);

        static SyncedStatus create(UneartherCoreBlockEntity core) {
            BlockState blockState;
            int processingTime = core.getCurrentRecipe().map(UneartherRecipe::getProcessingTime).orElse(0);
            int boost = core.getEffectiveSpeedBoost();
            Item item = core.getInputStack().getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                blockState = bi.getBlock().defaultBlockState();
            } else {
                blockState = Blocks.AIR.defaultBlockState();
            }
            BlockState state = blockState;
            return new SyncedStatus(state, processingTime * 100 / (100 + boost));
        }

        public boolean active() {
            return this.processingTime > 0;
        }
    }

    private abstract class FilteredInsertOnlyHandler
    extends ItemStackHandler {
        private final Predicate<ItemStack> filter;

        public FilteredInsertOnlyHandler(Predicate<ItemStack> filter) {
            super(1);
            this.filter = filter;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return super.isItemValid(slot, stack) && this.filter.test(stack);
        }

        protected void onContentsChanged(int slot) {
            UneartherCoreBlockEntity.this.setChanged();
            UneartherCoreBlockEntity.this.recheckRecipe = true;
        }
    }
}

