/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import dev.ftb.mods.ftbunearthed.block.UneartherCoreBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class UneartherRenderer
implements BlockEntityRenderer<UneartherCoreBlockEntity> {
    private final BlockEntityRendererProvider.Context ctx;

    public UneartherRenderer(BlockEntityRendererProvider.Context ctx) {
        this.ctx = ctx;
    }

    public void render(UneartherCoreBlockEntity unearther, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        UneartherCoreBlockEntity.SyncedStatus status;
        if (unearther.getLevel().isLoaded(unearther.getBlockPos()) && !(status = unearther.getSyncedStatus()).blockState().isAir()) {
            Direction d = (Direction)unearther.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            poseStack.pushPose();
            poseStack.translate(0.5 * (double)d.getStepX(), 0.5, 0.5 * (double)d.getStepZ());
            this.renderBlock(poseStack, bufferSource, packedLight, packedOverlay, status.blockState().getBlock(), unearther.getClientBreakProgress());
            poseStack.popPose();
        }
    }

    public void renderBlock(PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn, Block block, int breakProgress) {
        MultiBufferSource.BufferSource b = Minecraft.getInstance().levelRenderer.renderBuffers.crumblingBufferSource();
        SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(b.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(breakProgress)), poseStack.last(), 1.0f);
        MultiBufferSource bufferSource1 = arg_0 -> UneartherRenderer.lambda$renderBlock$0(bufferSource, (VertexConsumer)vertexconsumer, arg_0);
        BlockState state = block.defaultBlockState();
        this.ctx.getBlockRenderDispatcher().renderSingleBlock(state, poseStack, bufferSource1, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlock$0(MultiBufferSource bufferSource, VertexConsumer vertexconsumer, RenderType type) {
        VertexConsumer vc = bufferSource.getBuffer(type);
        return type.affectsCrumbling() ? VertexMultiConsumer.create((VertexConsumer)vertexconsumer, (VertexConsumer)vc) : vc;
    }
}

