/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.client;

import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.menu.UneartherMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UneartherScreen
extends AbstractContainerScreen<UneartherMenu> {
    private static final ResourceLocation TEXTURE = FTBUnearthed.id("textures/gui/unearther.png");
    private static final ResourceLocation BURN_PROGRESS_SPRITE = FTBUnearthed.id("progress_arrow");
    private static final int FOOD_BAR_HEIGHT = 50;

    public UneartherScreen(UneartherMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 176;
        this.inventoryLabelY = 74;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 7435898, false);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (x >= this.leftPos + 8 && x <= this.leftPos + 14 && y >= this.topPos + 18 && y <= this.topPos + 68) {
            int boost;
            boolean superBrush = ((UneartherMenu)this.menu).getUnearther().hasSuperBrush();
            int n = boost = superBrush ? ((Integer)ServerConfig.SUPER_BRUSH_SPEED_BOOST.get()).intValue() : ((UneartherMenu)this.menu).getSpeedBoost();
            if (boost > 0) {
                String remaining = superBrush ? "\u221e" : TimeUtils.getTimeString((long)((int)(((UneartherMenu)this.menu).getFoodBuffer() * (float)((Integer)ServerConfig.MAX_FOOD_BUFFER.get()).intValue() * 50.0f)));
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"ftbunearthed.gui.speed_boost", (Object[])new Object[]{boost}), Component.translatable((String)"ftbunearthed.gui.food_remaining", (Object[])new Object[]{remaining}).withStyle(ChatFormatting.GRAY)), Optional.empty(), x, y);
            } else {
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"ftbunearthed.gui.no_food.1"), Component.translatable((String)"ftbunearthed.gui.no_food.2").withStyle(ChatFormatting.GRAY)), Optional.empty(), x, y);
            }
        } else if (x >= this.leftPos + 45 && x <= this.leftPos + 48 && y >= this.topPos + 52 && y <= this.topPos + 70) {
            int xpProgress = WorkerToken.getXPProgress(((UneartherMenu)this.getMenu()).getSlot(38).getItem());
            MutableComponent line = Component.translatable((String)"ftbunearthed.tooltip.worker_xp_progress", (Object[])new Object[]{Component.literal((String)String.valueOf(xpProgress))});
            guiGraphics.renderTooltip(this.font, (Component)line, x, y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int xpProgress;
        int color;
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int uwidth = Mth.ceil((float)(((UneartherMenu)this.menu).getProgress() * 24.0f));
        guiGraphics.blitSprite(BURN_PROGRESS_SPRITE, 24, 16, 0, 0, this.leftPos + 86, this.topPos + 18, uwidth, 16);
        boolean superBrush = ((UneartherMenu)this.menu).getUnearther().hasSuperBrush();
        float foodBuf = superBrush ? 1.0f : ((UneartherMenu)this.menu).getFoodBuffer();
        int colorFrom = superBrush ? -14638944 : -14639072;
        int n = color = superBrush ? -16744320 : -16744448;
        if (foodBuf > 0.0f) {
            int fHeight = Math.max(1, (int)(50.0f * foodBuf));
            guiGraphics.fillGradient(this.leftPos + 8, this.topPos + 18 + (50 - fHeight), this.leftPos + 14, this.topPos + 18 + 50 + 1, colorFrom, color);
        }
        if ((xpProgress = WorkerToken.getXPProgress(((UneartherMenu)this.getMenu()).getSlot(38).getItem())) > 0) {
            int y1 = (int)(69.0f - 16.0f * (float)xpProgress / 100.0f);
            guiGraphics.fill(this.leftPos + 45, this.topPos + y1, this.leftPos + 48, this.topPos + 69, -6226112);
        }
    }
}

