/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.config;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerType;

public interface ServerConfig {
    public static final SNBTConfig SERVER_CONFIG = SNBTConfig.create((String)"ftbunearthed-server");
    public static final SNBTConfig GENERAL = SERVER_CONFIG.addGroup("general");
    public static final DoubleValue MANUAL_BRUSHING_SPEEDUP = (DoubleValue)GENERAL.addDouble("manual_brushing_speedup", 4.0, 0.05, Double.MAX_VALUE).comment(new String[]{"Recipe duration multiplier for manual brushing, higher is faster", "Recipe duration is divided by this value when using a brush manually."});
    public static final IntValue ENCODER_MAX_USES = (IntValue)GENERAL.addInt("encoder_max_uses", 10, 1, Integer.MAX_VALUE).comment(new String[]{"Maximum number of times an encode may be used"});
    public static final BooleanValue ENCODER_KEEPS_VILLAGER_LEVEL = (BooleanValue)GENERAL.addBoolean("encoder_keeps_village_level", false).comment(new String[]{"When encoding a villager, should the villager's level be preserved?", "Setting this to true makes the Encoder a convenient way to move villagers around..."});
    public static final StringValue ENCODED_VILLAGER_TYPE = (StringValue)GENERAL.addString("encoded_villager_type", "ftb:stone").comment(new String[]{"Villager type to force encoding to. If this is empty or an invalid villager type,", "the villager current type is kept."});
    public static final SNBTConfig UNEARTHER = SERVER_CONFIG.addGroup("unearther");
    public static final IntValue MAX_FOOD_BUFFER = (IntValue)UNEARTHER.addInt("max_food_buffer", 24000, 1, Integer.MAX_VALUE).comment(new String[]{"Maximum amount of food points (drumsticks) that can be stored in an Unearther"});
    public static final IntValue FOOD_SATURATION_MULTIPLIER = (IntValue)UNEARTHER.addInt("food_saturation_multiplier", 1, 1, Integer.MAX_VALUE).comment(new String[]{"Used to multiply the amount of saturation a food item can provide", "Food saturation determines how long the speed boost will last"});
    public static final IntValue FOOD_SPEED_BOOST_MULTIPLIER = (IntValue)UNEARTHER.addInt("food_speed_boost_multiplier", 1, 1, Integer.MAX_VALUE).comment(new String[]{"Used to multiply the amount of speed boost a food item can provide"});
    public static final IntValue SUPER_BRUSH_SPEED_BOOST = (IntValue)UNEARTHER.addInt("super_brush_speed_boost", 100, 1, Integer.MAX_VALUE).comment(new String[]{"Speed boost provided when a Super Brush is in use."});

    public static Optional<VillagerType> encodedVillagerType() {
        if (!((String)ENCODED_VILLAGER_TYPE.get()).isEmpty()) {
            try {
                ResourceLocation typeId = ResourceLocation.parse((String)((String)ENCODED_VILLAGER_TYPE.get()));
                return BuiltInRegistries.VILLAGER_TYPE.getOptional(ResourceKey.create((ResourceKey)Registries.VILLAGER_TYPE, (ResourceLocation)typeId)).or(() -> {
                    FTBUnearthed.LOGGER.error("unknown 'encoded_villager_type' {}, ignoring", ENCODED_VILLAGER_TYPE.get());
                    return Optional.empty();
                });
            }
            catch (ResourceLocationException e) {
                FTBUnearthed.LOGGER.error("invalid 'encoded_villager_type' {}, ignoring", ENCODED_VILLAGER_TYPE.get());
            }
        }
        return Optional.empty();
    }
}

