/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.crafting;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbunearthed.util.MiscUtil;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;

public record ItemWithChance(ItemStack item, double chance) implements WeightedEntry
{
    public static final Codec<ItemWithChance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.CODEC.fieldOf("item").forGetter(ItemWithChance::item), (App)Codec.DOUBLE.validate(MiscUtil::validateChanceRange).fieldOf("chance").forGetter(ItemWithChance::chance)).apply((Applicative)builder, ItemWithChance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemWithChance> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemWithChance::item, (StreamCodec)ByteBufCodecs.DOUBLE, ItemWithChance::chance, ItemWithChance::new);

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("item", (Object)this.item).add("chance", this.chance).toString();
    }

    public Weight getWeight() {
        return Weight.of((int)((int)(this.chance * 1000.0)));
    }

    public void tryProduce(RandomSource rand, Consumer<ItemStack> consumer) {
        int count = (int)this.chance();
        double chance = this.chance() - (double)count;
        if (rand.nextDouble() < chance) {
            ++count;
        }
        if (count > 0) {
            int toAdd;
            for (int actual = this.item.getCount() * count; actual > 0; actual -= toAdd) {
                toAdd = Math.min(actual, this.item.getMaxStackSize());
                consumer.accept(this.item.copyWithCount(toAdd));
            }
        }
    }
}

