/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.crafting.recipe;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public abstract class BaseRecipe<T extends Recipe<?>>
implements Recipe<RecipeWrapper> {
    private final RecipeSerializer<T> serializer;
    private final RecipeType<T> recipeType;

    protected BaseRecipe(Supplier<RecipeSerializer<T>> serializer, Supplier<RecipeType<T>> recipeType) {
        this.serializer = serializer.get();
        this.recipeType = recipeType.get();
    }

    public boolean matches(RecipeWrapper inv, Level world) {
        return true;
    }

    public ItemStack assemble(RecipeWrapper input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<T> getSerializer() {
        return this.serializer;
    }

    public RecipeType<T> getType() {
        return this.recipeType;
    }
}

