/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.datagen.recipe;

import dev.ftb.mods.ftbunearthed.crafting.ItemWithChance;
import dev.ftb.mods.ftbunearthed.crafting.recipe.UneartherRecipe;
import dev.ftb.mods.ftbunearthed.datagen.recipe.BaseRecipeBuilder;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;

public class UneartherRecipeBuilder
extends BaseRecipeBuilder<UneartherRecipe> {
    private final String inputStateStr;
    private final WorkerToken.WorkerData workerData;
    private final Ingredient toolItem;
    private final List<ItemWithChance> outputs;
    private int processingTime;
    private float damageChance;

    public UneartherRecipeBuilder(String inputStateStr, WorkerToken.WorkerData workerData, Ingredient toolItem, List<ItemWithChance> outputs) {
        this.inputStateStr = inputStateStr;
        this.workerData = workerData;
        this.toolItem = toolItem;
        this.outputs = outputs;
        this.processingTime = 200;
        this.damageChance = 1.0f;
    }

    public UneartherRecipeBuilder withProcessingTime(int time) {
        this.processingTime = time;
        return this;
    }

    public UneartherRecipeBuilder withToolDamageChance(float damageChance) {
        this.damageChance = damageChance;
        return this;
    }

    @Override
    protected UneartherRecipe buildRecipe() {
        return new UneartherRecipe(this.inputStateStr, this.workerData, this.toolItem, this.processingTime, this.outputs, this.damageChance);
    }
}

