/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.item;

import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class EchoEncoder
extends Item {
    public EchoEncoder(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Villager villager;
        if (interactionTarget instanceof Villager && (villager = (Villager)interactionTarget).getAge() >= 0) {
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (EchoEncoder.getUseCount(stack) >= (Integer)ServerConfig.ENCODER_MAX_USES.get()) {
                    player.displayClientMessage((Component)Component.translatable((String)"ftbunearthed.message.item_too_damaged", (Object[])new Object[]{stack.getHoverName()}).withStyle(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                ItemStack token = WorkerToken.createWithData(WorkerToken.WorkerData.fromVillagerData(villager.getVillagerData()));
                Block.popResource((Level)player.level(), (BlockPos)villager.blockPosition(), (ItemStack)token);
                serverLevel.playSound(null, villager.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 pos = villager.getPosition(1.0f).add(0.0, 1.0, 0.0);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y, pos.z, 50, 0.2, 0.5, 0.2, 0.0);
                villager.setTradingPlayer(null);
                villager.releasePoi(MemoryModuleType.HOME);
                villager.releasePoi(MemoryModuleType.JOB_SITE);
                villager.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
                villager.releasePoi(MemoryModuleType.MEETING_POINT);
                villager.discard();
                EchoEncoder.incrementUseCount(stack);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int remaining = (Integer)ServerConfig.ENCODER_MAX_USES.get() - EchoEncoder.getUseCount(stack);
        tooltipComponents.add((Component)Component.translatable((String)"ftbunearthed.tooltip.echo_encoder_charges", (Object[])new Object[]{remaining}).withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"ftbunearthed.tooltip.echo_encoder_usage").withStyle(ChatFormatting.GRAY));
    }

    public int getBarWidth(ItemStack stack) {
        float amount = Mth.clamp((float)((float)EchoEncoder.getUseCount(stack) / (float)((Integer)ServerConfig.ENCODER_MAX_USES.get()).intValue()), (float)0.0f, (float)1.0f);
        return Math.round(13.0f - amount * 13.0f);
    }

    public int getBarColor(ItemStack stack) {
        int amount = (int)(64.0f + 191.0f * Mth.clamp((float)((float)((Integer)ServerConfig.ENCODER_MAX_USES.get() - EchoEncoder.getUseCount(stack)) / (float)((Integer)ServerConfig.ENCODER_MAX_USES.get()).intValue()), (float)0.0f, (float)1.0f));
        return 0xFF200000 | amount << 8 | amount;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public static int getUseCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.ENCODER_USES, (Object)0);
    }

    private static void incrementUseCount(ItemStack stack) {
        stack.set(ModDataComponents.ENCODER_USES, (Object)(EchoEncoder.getUseCount(stack) + 1));
    }
}

